#include "mbed.h"
#include "rtos.h"

void        proxy_thread(void const *argument);
DigitalOut  led1(LED1);
DigitalOut  led2(LED2);
InterruptIn fire(p14);
Thread      *proxy_ptr;

/*
 * PROXY thread that works with and is triggered by the ISR
 */

void proxy_thread(void const *argument) {
    while (true) { 
        printf("proxy - waiting for  signal \n\r");    
        Thread::signal_wait(0x1, osWaitForever);
        printf("proxy - got signal \n\r");
        led1 = !led1;
    }
}


/*
 * ISR - does minimal work and passes the buck to PROXY thread
 */

void ISR1() {
    led2 = !led2;
    proxy_ptr->signal_set(0x1);
}




int main (void) {
    
    fire.rise(&ISR1);
    Thread thread(proxy_thread);
    proxy_ptr = &thread;  
    
    printf("main ... testing signals\n\r");
    while (true) {
        Thread::wait(1000);
        printf("main ... wait loop\n\r");
    }
}
