#include "mbed.h"
#include "cmsis_os.h"
#include "rtos.h"
 
Serial pc(USBTX, USBRX);
 

/*
typedef enum  {
  osPriorityIdle          = -3,          ///< priority: idle (lowest)
  osPriorityLow           = -2,          ///< priority: low
  osPriorityBelowNormal   = -1,          ///< priority: below normal
  osPriorityNormal        =  0,          ///< priority: normal (default)
  osPriorityAboveNormal   = +1,          ///< priority: above normal
  osPriorityHigh          = +2,          ///< priority: high 
  osPriorityRealtime      = +3,          ///< priority: realtime (highest)
  osPriorityError         =  0x84        ///< system cannot determine priority or thread has illegal priority
} osPriority;
*/


DigitalOut led1(LED1);
DigitalOut led2(LED2);

/*
 * This thread just flips the led2
 */
 
 
void led2_thread(void const *args) {
    while (true) {
        led2 = !led2;
        Thread::wait(1000);
    }
}


/*
 * This thread does non blocking read
 */
 
void nbread_thread(void const *args) {
    while(1) {
        if(pc.readable()) {
            pc.printf("got a character: %c\r\n", pc.getc());
         }
         
         Thread::wait(10);
    }
}

/* 
 * the main thread sets upthread priorities and flips led's
 */
 
int main() {
    
    osPriority pri;
    Thread thread(led2_thread);
    Thread thread1(nbread_thread);
    
    pc.printf("testing thread features \r\n");
    printf("led2_thread priority: %d\r\n", thread.get_priority());
    pri = osPriorityHigh;
    thread.set_priority(pri);
    printf("led2_thread priority: %d\r\n", thread.get_priority());
    while (true) {
        led1 = !led1;
        Thread::wait(500);
    }
}
