
#include "mbed.h"
#include "EthernetInterface.h"
#include "Socket.h"
#include "TCPSocketServer.h"
#include "TCPSocketConnection.h"
 
DigitalOut myled(LED1);
Serial tty_pc(USBTX, USBRX);
 
void eth_main(const void *context)
{
    puts("Starting " __FILE__ " " __DATE__ " " __TIME__);
        
    Ethernet eth;
    eth.set_link(eth.AutoNegotiate);
 
    EthernetInterface ethif;
    ethif.init();
    ethif.connect();
 
    printf("IP %s\n", ethif.getIPAddress());
 
    TCPSocketServer server;
    TCPSocketConnection sock;
    bool active = false;
    unsigned short port = 8000;
 
    server.bind(port);
    server.listen();
 
    server.set_blocking(false, 500); // SET NON-BLOCKING
 
    printf("listening at %s:%hu\n", ethif.getIPAddress(), port);
 
    while(true)
    {
        myled = eth.link();
 
        if (active)
        {
       
#ifdef OLD
            char c;
            if (sock.receive(&c, 1) <= 0) // NON-BLOCKING (!?) RECEIVE TO CHECK IF SOCKET ACTIVE
                Thread::wait(500);
#endif               
            if (!sock.is_connected())
            {
                puts("connection closed");
                sock.close(true);
                active = false;
                server.bind(port);
                server.listen();
                printf("listening at %s:%hd\n", ethif.getIPAddress(), port);
            }
        }
        else
        {
            if (server.accept(sock) == 0)
            {
                active = true;
                server.close();
                puts("connection established");
            }
        }
    }
}
 
int main()
{
    Thread eth_thread(eth_main, 0);
    
    while (1)
    {
        // forever
    }
}
