//#define BASIC
#ifdef BASIC
#include "mbed.h"
#include "m3pi.h"

m3pi m3pi;

int main() {

    m3pi.locate(0,1);
    m3pi.printf("LO World");

    wait (2.0);

    m3pi.forward(0.5); // Forward half speed
    wait (0.5);        // wait half a second
    m3pi.left(0.5);    // Turn left at half speed
    wait (0.5);        // wait half a second
    m3pi.backward(0.5);// Backward at half speed 
    wait (0.5);        // wait half a second
    m3pi.right(0.5);   // Turn right at half speed
    wait (0.5);        // wait half a second

    m3pi.stop();       
}

#else  
#include "mbed.h"
#include "m3pi.h"
#include "WiflyInterface.h"

m3pi m3pi;
int  echo();


int main() {

    m3pi.locate(0,1);
    m3pi.printf("LO World");

    wait (2.0);

    m3pi.forward(0.5); // Forward half speed
    wait (0.5);        // wait half a second
    m3pi.left(0.5);    // Turn left at half speed
    wait (0.5);        // wait half a second
    m3pi.backward(0.5);// Backward at half speed 
    wait (0.5);        // wait half a second
    m3pi.right(0.5);   // Turn right at half speed
    wait (0.5);        // wait half a second
    m3pi.stop(); 
    
    m3pi.stop();
    //echo();      
}



#define ECHO_SERVER_PORT   7

/* wifly object where:
*     - p9 and p10 are for the serial communication
*     - p25 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/

WiflyInterface wifly(p9, p10, p25, p26, "bubbles", "", NONE);

int echo (void)
{
    wifly.init(); // use DHCP
    while (!wifly.connect()); // join the network
    m3pi.printf("IP Address:port %s:%d\n\r", wifly.getIPAddress(), 7);

    TCPSocketServer server;
    
    server.bind(ECHO_SERVER_PORT);
    server.listen();

    m3pi.printf("\nWait for new connection...\n");
    TCPSocketConnection client;
    server.accept(client);

    char buffer[256];
    while (true) {
        int n = client.receive(buffer, sizeof(buffer));
        if (n <= 0) continue;
        buffer[n] = 0;

        client.send_all(buffer, n);
    }
}
#endif

