#include "mbed.h"
#include "LM75B.h"
#include "C12832_lcd.h"
#include "rtos.h"

// instantiate hardware peripherals
LM75B tmpSns(p28,p27);
C12832_LCD lcd;
Serial pc(USBTX, USBRX); // tx, rx; used only if errors encountered

// mutex to make the lcd lib thread safe
Mutex lcd_mutex;

AnalogIn Pot1(p19);

typedef unsigned short potVal_t;
typedef float  tempVal_t;

//Potentiometer values memory pool
MemoryPool<potVal_t, 16> potVal_mpool;
Queue<potVal_t, 16> potVal_queue;

//Temperature sensor values memory pool
MemoryPool<tempVal_t, 16> tempVal_mpool;
Queue<tempVal_t, 16> tempVal_queue;


// Thread  potVal_send_thread()
// Pot1 sends value to LCD thread via IPC Queue
void potVal_send_thread(void const *args)
{
    potVal_t *potValMessage;

    while(true)
    {
//        potVal_t *potValMessage = potVal_mpool.alloc();
        potValMessage = potVal_mpool.alloc();
        if (potValMessage == NULL) {
                pc.printf("****\n\r");
                continue;
        }
        *potValMessage = Pot1.read_u16(); // get Pot1 value
        potVal_queue.put(potValMessage, 1000);  // put it in the queue
        Thread::wait(2000);    
        pc.printf("potVal_send_thread executing\n\r");
        
        
        
    }
}

// Thread  tempVal_send_thread()
// Temperature sensor sends value to LCD thread via IPC Queue
void tempVal_send_thread(void const *args)
{
    float *tempValMessage;
    while(true)
    {
//        float *tempValMessage = tempVal_mpool.alloc();
        tempValMessage = tempVal_mpool.alloc();
        if (tempValMessage == NULL){
                pc.printf("***\n\r");
                continue;
        }
        *tempValMessage = ((tmpSns.read()*9/5)+32);// get Temp update
        tempVal_queue.put(tempValMessage, 1000);  // put value in the queue
        Thread::wait(2000); 
        pc.printf("tempVal_send_thread executing\n\r");
    }
}

void lcd_thread(void const *args) 
{   
    osEvent evt1;
    osEvent evt2;
    
    float *tempVal;
    potVal_t *pot1Val;
    
    
    while (true) 
    {
     //   osEvent evt1 = potVal_queue.get();
        evt1 = potVal_queue.get(1000);                      // note timeout
        if (evt1.status == osEventMessage) 
        {
            potVal_t *pot1Val = (potVal_t*)evt1.value.p;
            pot1Val = (potVal_t*)evt1.value.p;
            lcd_mutex.lock(); // exclude other thread access to lcd 
            lcd.locate(0,0);
            lcd.printf("Pot1=%d\n\r", *pot1Val);
            lcd_mutex.unlock();
            potVal_mpool.free(pot1Val);
        }
        
        pc.printf("evt1 %d\n\r", evt1.status);
        
      //  osEvent evt2 = tempVal_queue.get();
        evt2 = tempVal_queue.get(1000);                 /// note timeout
        if (evt2.status == osEventMessage) 
        {
//          float *tempVal = (float*)evt2.value.p;
            tempVal = (float*)evt2.value.p;
            lcd_mutex.lock(); // exclude other thread access to lcd 
            lcd.locate(0,2);
            lcd.printf("Temp=%3.1f\n\r", *tempVal);
            lcd_mutex.unlock();
            tempVal_mpool.free(tempVal);
        }
        pc.printf("evt2 %d\n\r", evt2.status);
        
        Thread::wait(500);  
        pc.printf("LCD  executing\n\r");                                   // note wait()
        
    }
}

int main() {
    
    osPriority pri;

    
    
    pc.printf("main started...\n\r");
    lcd.cls();
    Thread thread1(potVal_send_thread);
    pc.printf("\nthree threads started...");
    Thread thread2(lcd_thread);
    Thread thread3(tempVal_send_thread);
    pri = osPriorityHigh;
    thread2.set_priority(pri);                           // make sure lcd thread is receiving data and flushing IPC 
    pc.printf("three threads started...\n\r");

    while(true)
    {
        Thread::wait(1000);
        pc.printf("main thread executing\n\r");
    }
}

