// Temperature resource implementation

#include "mbed.h"
#include "rtos.h"
#include "LM75B.h"
#include "nsdl_support.h"
#include "temperature.h"

#define TEMP_RES_ID     "sen/temp"

static LM75B tmp(p28,p27);
/* stored data for observable resource */
static uint8_t obs_number = 0;
static uint8_t *obs_token_ptr = NULL;
static uint8_t obs_token_len = 0;
static char temp_val[5];
extern Serial pc;

/* Thread for calling libNsdl exec function (cleanup, resendings etc..) */
/* Node updates temperature every 10 seconds. Notification sending is done here. */
static void exec_call_thread(void const *args)
{
    int32_t time = 0;
    while (true)
    {
        wait(1);
        time++;
        sn_nsdl_exec(time);
        if((!(time % 10)) && obs_number != 0 && obs_token_ptr != NULL)
        {
            obs_number++;
            sprintf(temp_val,"%2.2f" ,tmp.read());
            if(sn_nsdl_send_observation_notification(obs_token_ptr, obs_token_len, (uint8_t*)temp_val, 5, &obs_number, 1, COAP_MSG_TYPE_NON_CONFIRMABLE, 0) == 0)
                pc.printf("Observation sending failed\r\n");
            else
                pc.printf("Observation\r\n");
        }
    }
}

/* Only GET method allowed */
/* Observable resource */
static uint8_t temp_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sprintf(temp_val,"%2.2f" ,tmp.read());
    sn_coap_hdr_s *coap_res_ptr = 0;

    pc.printf("temp callback\r\n");
    coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

    coap_res_ptr->payload_len = 5;
    coap_res_ptr->payload_ptr = (uint8_t*)temp_val;

    if(received_coap_ptr->token_ptr)
    {
        pc.printf("Token included\r\n");
        if(obs_token_ptr)
        {
            free(obs_token_ptr);
            obs_token_ptr = 0;
        }
        obs_token_ptr = (uint8_t*)malloc(received_coap_ptr->token_len);
        if(obs_token_ptr)
        {
            memcpy(obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
            obs_token_len = received_coap_ptr->token_len;
        }
    }

    if(received_coap_ptr->options_list_ptr->observe)
    {
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)malloc(sizeof(sn_coap_options_list_s));
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->observe_ptr = &obs_number;
        coap_res_ptr->options_list_ptr->observe_len = 1;
        obs_number++;
    }

    sn_nsdl_send_coap_message(address, coap_res_ptr);

    coap_res_ptr->options_list_ptr->observe_ptr = 0;
    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    return 0;
}

int create_temperature_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    static Thread exec_thread(exec_call_thread);
    
    nsdl_create_dynamic_resource(resource_ptr, sizeof(TEMP_RES_ID)-1, (uint8_t*)TEMP_RES_ID, 0, 0, 1, &temp_resource_cb, SN_GRS_GET_ALLOWED);    
    return 0;
}