

#include "mbed.h"
#include "GPS.h"
#include "rtos.h"
#include <string>
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "SimpleSMTPClient.h"

using namespace std;

const string GoogleChunk = "https://maps.google.com/?q=";   // URL constant
const string GoogleExtras = "";                               // Zoom Level (0-20)
char GPRSbuffer[512];
char NUMBER[13];    
string MESSAGE;
int index;
int i = 0;
float   latitude;
float   longitude;
char    message[256];

GPS gps(p9,p10);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

void led_thread(void const *argument)                                  
{
    while (true) {
        DigitalOut leds[4] = {myled1, myled2, myled3, myled4};
        int pattern[6][4] = {{1,0,0,0},{0,1,0,0},{0,0,1,0},{0,0,0,1},{0,0,1,0},{0,1,0,0}};
        int i=0;
        while(1) {
            leds[0] = pattern[i][0];
            leds[1] = pattern[i][1];
            leds[2] = pattern[i][2];
            leds[3] = pattern[i][3];
            wait(0.2);
            i++;
            i == 6? i=0:0;
        }
    }
}


#define DOMAIN "comcast.net"
#define SERVER "smtp.comcast.net"
#define PORT "587" //25 or 587,465(OutBound Port25 Blocking )
#define USER "avnisha"
#define PWD "Bubbles1231"
#define FROM_ADDRESS "avnisha@comcast.net"
#define TO_ADDRESS "avnisha@comcast.net" 
#define SUBJECT "Test Mail"

int sms_setup()
{
    EthernetInterface eth;
    char strTimeMsg[16];

    printf("Setting up SMS ...\n");
    eth.init();
    eth.connect();
    printf("Connected OK\n");

    // IP Address 
    
    printf("IP Address is %s\n", eth.getIPAddress());
    printf("%s", eth.getIPAddress());

    // NTP Client
    printf("NTP setTime...\n");
    NTPClient ntp;
    ntp.setTime("pool.ntp.org");
    
    time_t ctTime = time(NULL)+32400; // JST
    printf("\nTime is now (JST): %d %s\n", ctTime, ctime(&ctTime));
    strftime(strTimeMsg,16,"%y/%m/%d %H:%M",localtime(&ctTime)); 
    printf("[%s]",strTimeMsg);
    
    return 1;

}

int sms_send(char *message) {

    SimpleSMTPClient smtp;
    int ret;
    char msg[]="Hello SimpleSMTPClient ";
    
    smtp.setFromAddress(FROM_ADDRESS);
    smtp.setToAddress(TO_ADDRESS);
    smtp.setMessage(SUBJECT,msg);
    smtp.addMessage(message);
    
    //
    // send as SMS text 
    //
    
    smtp.setFromAddress(FROM_ADDRESS);
    smtp.setToAddress("5105794214@txt.att.net");                // MODIFY for carrier
    smtp.setMessage(SUBJECT,msg);
    smtp.addMessage(message);
  
    ret = smtp.sendmail(SERVER, USER, PWD, DOMAIN,PORT,SMTP_AUTH_PLAIN);
 
    if (ret) {
        printf("SMS Transmission Error\r\n");
    } else {
        printf("SMS Transmission OK\r\n");
    }
 
    return 0;

}

int getGPS() {

#define CANNED
#ifdef CANNED
    printf("CANNED GPS\n\r");
    longitude = -201;
    latitude = 37;
    return 1;
#endif
    if(gps.sample()) {
        printf("I'm at %f, %f\n", gps.longitude, gps.latitude);
    } else {
        printf("Oh Dear! No lock :(\n");
        return 0;
    }
       
    longitude = gps.longitude;
    latitude = gps.latitude;
    return 1;
}

void sendGPS()
{
  
    sprintf(message, "Find me at....\n %s%f,%f%s", GoogleChunk, latitude, longitude, GoogleExtras);
    sms_send(message);
    
}


int main()
{
    
    //Thread thread(led_thread);
    
    printf("Send GPS SMS message\r\n");
    sms_setup();
    
    // Get in a while loop
    
    while (1) {
        if (getGPS()) {
            sendGPS();
        }
        
        wait(600);
    }
}


