#include "mbed.h"
 
SPI spi(p11, p12, p13); // mosi, miso, sclk
DigitalOut cs(p14);
SPISlave device(p5, p6, p7, p8); // mosi, miso, sclk, ssel
 
char    receive = 0;             // returned by slave
char    send = 0;               // sent by master
 
void slave_init() {
    device.reply(receive++);
    return;
}
 

int main() {

    int     slave_byte;

    // init slave
    
    slave_init();
    
    // Chip must be deselected
    
    cs = 1;

    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    
    spi.format(8,3);
    spi.frequency(1000000);;
 
    while (1) {
        cs = 0;
        slave_byte = spi.write(send++);
        printf("slave byte = 0x%X\r\n", slave_byte);
        cs = 1;
        slave_init();               // give slave SPI time slice 
        wait(1);
    }
     
}

 