#include "mbed.h"

/*
 * Book - 9.10 (page 198)
 * 
 * Switch debounce based on a simple 50ms wait before next event processed
 * Note - the wait time DEPENDS on your switch. Experiment !!!
 */

DigitalOut  led1(LED1);
DigitalOut  led2(LED2);
InterruptIn button(p12);
Timer       debounce;

void    rise(void);
void    fall(void);

int main() {
    debounce.start();
    button.rise(&rise);  
    //button.fall(&fall);    
}

void    rise() {
    printf("rise\n");
    if (debounce.read_ms() > 50) {
        led1 = !led1;
        debounce.reset();
    }
}

void    fall() {
    printf("fall\n");
    if (debounce.read_ms() > 50) {
        led2 = !led2;
        debounce.reset();
    }
}