/*Program Example 9.10: Metronome. Uses Ticker to set beat rate
 
 
//BusIn joy(p15,p12,p13,p16);  
                                                                    */            
#include "mbed.h"
#include <stdio.h>
Serial pc(USBTX, USBRX);
DigitalIn up_button(p15);
DigitalIn down_button(p16);
DigitalOut redled(LED1);             //displays the metronome beat
Ticker beat_rate;                   //define a Ticker, with name “beat_rate”
void beat(void);
float period (1);              //metronome period in seconds, inital value 0.5
int rate (60);                  //metronome rate, initial value 120

int main() {
  pc.printf("\r\n");
  pc.printf("mbed metronome!\r\n");
  pc.printf("_______________\r\n");
  period = 1;
  redled = 1;        //diagnostic
  wait(.1);
  redled = 0;
  beat_rate.attach(&beat, period);  //initialises the beat rate 
  //main loop checks buttons, updates rates and displays
  while(1){
    if (up_button ==1)   //increase rate by 4
      rate = rate + 4;
    if (down_button ==1)   //decrease rate by 4
      rate = rate - 4;
    if (rate > 208)        //limit the maximum beat rate to 208
      rate = 208;
    if (rate < 40)      //limit the minimum beat rate to 40
      rate = 40;
    period = 60/rate;       //calculate the beat period
    pc.printf("metronome rate is %i\r", rate);
    //pc.printf("metronome period is %f\r\n", period);  //optional check
    wait (0.5);
  }
}

  void beat() {                         //this is the metronome beat
    beat_rate.attach(&beat, period);    //update beat rate at this moment
    redled = 1;
    wait(.1);
    redled = 0;
  }

