#define ETHERNET

#ifdef WIFLY
#include "mbed.h"
#include "WiflyInterface.h"

Serial pc(USBTX, USBRX);

/* wifly object where:
*     - p9 and p10 are for the serial communication
*     - p25 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p9, p10, p25, p26, "bubbles", "", NONE);

int main() {
    printf("hello\n\r");
    wifly.init(); // use DHCP
    while (!wifly.connect()); // join the network
    printf("IP Address is %s\n\r", wifly.getIPAddress());
    while (1) {}
    wifly.disconnect();
}

#endif

#include "mbed.h"
#include "EthernetInterface.h"
#include "xively.h"
#include "xi_err.h"
#include "xi_printf.h"

#ifdef WIFLY
#include "WiflyInterface.h"

Serial pc(USBTX, USBRX);

/* wifly object where:
*     - p9 and p10 are for the serial communication
*     - p25 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p9, p10, p25, p26, "bubbles", "", NONE);
#endif

#include <stdarg.h>
#include <stdio.h>

#include "MMA7660.h"
#include "LM75B.h"

// 332668647
// ZmCG3GmfnJzvt1LZnLdHfS9D5vlfNrXQSxKD1jpzqsAsp3bh
#define XI_FEED_ID 332668647 // set Xively Feed ID (numerical, no quoutes
#define XI_API_KEY "ZmCG3GmfnJzvt1LZnLdHfS9D5vlfNrXQSxKD1jpzqsAsp3bh" // set Xively API key (double-quoted string) 

#include "C12832_lcd.h"

C12832_LCD lcd;

MMA7660 axl(p28, p27);
LM75B tmp(p28, p27);

extern "C" {

void user_printf( const char* buffer )
{
    lcd.cls();
    lcd.locate( 0, 3 );
    lcd.printf( buffer );
    //wait( 1.0 );    
}

void mbed_printf( const char* fmt, ...  )
{
    char buffer[ 64 ];
    
    va_list ap;
    va_start( ap, fmt );
    vsnprintf( buffer, 64, fmt, ap );
    va_end( ap );
    
    user_printf( buffer );
}

}

int main() {
    // set our device specific print function
    USER_PRINT = user_printf;

#ifdef ETHERNET    
    EthernetInterface eth;
    
    int s = eth.init(); //Use DHCP
    
    if( s != NULL )
    {
        mbed_printf( "Could not initialise. Will halt!\n" );        
        exit( 0 );
    }    
        
    s = eth.connect();
    
    if( s != NULL )
    {
        mbed_printf( "Could not connect. Will halt!\n" );
        exit( 0 );
    }
    else 
    {
        mbed_printf( "IP: %s\n", eth.getIPAddress() );    
    }
#else
    wifly.init(); // use DHCP
    while (!wifly.connect()); // join the network
    printf("IP Address is %s\n\r", wifly.getIPAddress());
#endif

    xi_feed_t feed;
    memset( &feed, NULL, sizeof( xi_feed_t ) );
    
    feed.feed_id = XI_FEED_ID;
    feed.datastream_count = 3;
    
    feed.datastreams[0].datapoint_count = 1;
    xi_datastream_t* orientation_datastream = &feed.datastreams[0];
    strcpy( orientation_datastream->datastream_id, "orientation" );
    xi_datapoint_t* current_orientation = &orientation_datastream->datapoints[0];

    feed.datastreams[1].datapoint_count = 1;
    xi_datastream_t* side_rotation_datastream = &feed.datastreams[1];
    strcpy( side_rotation_datastream->datastream_id, "side_rotation" );
    xi_datapoint_t* current_side_rotation = &side_rotation_datastream->datapoints[0];
    
    feed.datastreams[2].datapoint_count = 1;
    xi_datastream_t* temperature_datastream = &feed.datastreams[2];
    strcpy( temperature_datastream->datastream_id, "temperature" );
    xi_datapoint_t* current_temperature = &temperature_datastream->datapoints[0];
    
    // create the cosm library context
    xi_context_t* xi_context
        = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );

    // check if everything works
    if( xi_context == NULL )
    {
        return -1;
    }
    
    mbed_printf("feed:%d datastreams:[%s,%s]\n", feed.feed_id,
                    orientation_datastream->datastream_id,
                    side_rotation_datastream->datastream_id);

    while(1) {
      
      switch( axl.getSide() ) {
        case MMA7660::Front:
          xi_set_value_str( current_side_rotation, "front" );
          break;
        case MMA7660::Back:
          xi_set_value_str( current_side_rotation, "back" );
          break;
        default:
          xi_set_value_str( current_side_rotation, "unknown" );
          break;
      }
      
      switch( axl.getOrientation() ) {
        case MMA7660::Down:
          mbed_printf("down %s\n",
            (axl.getSide() == MMA7660::Front ? "front" : "back"));
          xi_set_value_str( current_orientation, "down" );
          break;
        case MMA7660::Up:
           mbed_printf("up %s\n",
            (axl.getSide() == MMA7660::Front ? "front" : "back"));
           xi_set_value_str( current_orientation, "up" );
           break;
        case MMA7660::Right:
          mbed_printf("right %s\n",
            (axl.getSide() == MMA7660::Front ? "front" : "back"));
          xi_set_value_str( current_orientation, "right" );
          break;
        case MMA7660::Left:
          mbed_printf("left %s\n",
            (axl.getSide() == MMA7660::Front ? "front" : "back"));
          xi_set_value_str( current_orientation, "left" );
          break;
        default: 
          xi_set_value_str( current_orientation, "unknown" );
          break;
      }
      
      xi_set_value_f32( current_temperature, tmp.read() );
        
      mbed_printf( "update...\n" );
      xi_feed_update(xi_context, &feed);
      mbed_printf( "done...\n" );
      
      wait( 15.0 );
    }
}