

#include "mbed.h"
#include "MSCFileSystem.h"
#include "wavfile.h"

DigitalIn       record(p13);
DigitalIn       playback(p16);
AnalogOut       Aout(p18);
AnalogIn        pot1(p19);
Timeout         genTime;
int             genOn;
 
 
float   i = 0;
void    tickgen(void)
{
    Aout = i;    
    i = i + 0.1;
    if (i > 1.0) i = 0.0;
} 


void genTimeout() {
    genOn = 0;
}

void generate()
{
    while(genOn) {
        for(float i=0.0; i<1.0; i+=0.1) {
            Aout = i;
            wait(0.00001+(0.0001*pot1.read()));
        }
    }
}


#define RAM_TOTAL   0x1000

AnalogOut dacout(p18);
AnalogIn adcin(p17);
DigitalOut led_play_ok(LED1);
DigitalOut led_rec_ok(LED2);

Timer timer;
Timer iometer;
Ticker ticker;
Ticker tickgenerate;
MSCFileSystem fs("fs");

float buffer[RAM_TOTAL];
int rp = 0;
int wp = 0;
int dropout = 0;

#define WAVFILE_ERROR_PRINT(RESULT) \
    do { \
        WavFileResult R = RESULT; \
        if (R != WavFileResultOK) { \
            char wavfile_error_print_text[BUFSIZ]; \
            wavfile_result_string(R, wavfile_error_print_text, sizeof(wavfile_error_print_text)); \
            printf("%s (code=%d)\r\n", wavfile_error_print_text, R); \
            return 1; \
        } \
    } while(0)

void tickdummy(void)
{
}

void tickplay(void)
{
    /*
     * Check the play underflow
     */
    if (rp != wp) {
        dacout = buffer[rp];
        rp = (rp + 1) & (RAM_TOTAL - 1);
    } else {
        dropout++;
    }
    led_play_ok = !led_play_ok;
}

void tickrec(void)
{
    /*
     * Check the rec overflow
     */
    int np = (wp + 1) & (RAM_TOTAL - 1);
    if (np != rp) {
        buffer[wp] = adcin;
        wp = np;
    } else {
        dropout++;
    }
    led_rec_ok = !led_rec_ok;
}

int play(const char *filename)
{
    WavFileResult result;
    wavfile_info_t info;
    wavfile_data_t data;

    WAVFILE *wf = wavfile_open(filename, WavFileModeRead, &result);
    WAVFILE_ERROR_PRINT(result);
    WAVFILE_ERROR_PRINT(wavfile_read_info(wf, &info));

    //printf("[PLAY:%s]\r\n", filename);
    //printf("\tWAVFILE_INFO_AUDIO_FORMAT(&info)    = %d\r\n", WAVFILE_INFO_AUDIO_FORMAT(&info));
    //printf("\tWAVFILE_INFO_NUM_CHANNELS(&info)    = %d\r\n", WAVFILE_INFO_NUM_CHANNELS(&info));
    //printf("\tWAVFILE_INFO_SAMPLE_RATE(&info)     = %d\r\n", WAVFILE_INFO_SAMPLE_RATE(&info));
    //printf("\tWAVFILE_INFO_BYTE_RATE(&info)       = %d\r\n", WAVFILE_INFO_BYTE_RATE(&info));
    //printf("\tWAVFILE_INFO_BLOCK_ALIGN(&info)     = %d\r\n", WAVFILE_INFO_BLOCK_ALIGN(&info));
    //printf("\tWAVFILE_INFO_BITS_PER_SAMPLE(&info) = %d\r\n", WAVFILE_INFO_BITS_PER_SAMPLE(&info));

    const int interval_us =  1000000 / WAVFILE_INFO_SAMPLE_RATE(&info);

    rp = 0;
    wp = 0;
    dropout = 0;
    ticker.attach_us(tickplay, interval_us);
    while (1) {
        int np = (wp + 1) & (RAM_TOTAL - 1);
        while (np == rp) {
            wait_us(1);
        }
        WAVFILE_ERROR_PRINT(wavfile_read_data(wf, &data));
        if (WAVFILE_DATA_IS_END_OF_DATA(&data)) {
            break;
        }
        buffer[wp] = WAVFILE_DATA_CHANNEL_DATA(&data, 0);
        wp = np;
    }
    ticker.detach();
    dacout = 0.5;
    led_play_ok = 0;
    printf("\t-- Play done. (dropout=%d) --\r\n", dropout);

    WAVFILE_ERROR_PRINT(wavfile_close(wf));
    return 0;
}

int rec(const char *filename, const int nsec)
{
    WavFileResult result;
    wavfile_info_t info;
    wavfile_data_t data;

    WAVFILE_INFO_AUDIO_FORMAT(&info)    = 1;
    WAVFILE_INFO_NUM_CHANNELS(&info)    = 1;
    WAVFILE_INFO_SAMPLE_RATE(&info)     = 11025;
    WAVFILE_INFO_BYTE_RATE(&info)       = 22050;
    WAVFILE_INFO_BLOCK_ALIGN(&info)     = 2;
    WAVFILE_INFO_BITS_PER_SAMPLE(&info) = 16;

    WAVFILE *wf = wavfile_open(filename, WavFileModeWrite, &result);
    WAVFILE_ERROR_PRINT(result);
    WAVFILE_ERROR_PRINT(wavfile_write_info(wf, &info));

    //printf("[REC:%s]\r\n", filename);
    //printf("\tWAVFILE_INFO_AUDIO_FORMAT(&info)    = %d\r\n", WAVFILE_INFO_AUDIO_FORMAT(&info));
    //printf("\tWAVFILE_INFO_NUM_CHANNELS(&info)    = %d\r\n", WAVFILE_INFO_NUM_CHANNELS(&info));
    //printf("\tWAVFILE_INFO_SAMPLE_RATE(&info)     = %d\r\n", WAVFILE_INFO_SAMPLE_RATE(&info));
    //printf("\tWAVFILE_INFO_BYTE_RATE(&info)       = %d\r\n", WAVFILE_INFO_BYTE_RATE(&info));
    //printf("\tWAVFILE_INFO_BLOCK_ALIGN(&info)     = %d\r\n", WAVFILE_INFO_BLOCK_ALIGN(&info));
    //printf("\tWAVFILE_INFO_BITS_PER_SAMPLE(&info) = %d\r\n", WAVFILE_INFO_BITS_PER_SAMPLE(&info));

    const int interval_us =  1000000 / WAVFILE_INFO_SAMPLE_RATE(&info);
    const unsigned int samples_for_nsec = WAVFILE_INFO_SAMPLE_RATE(&info) * nsec;

    rp = 0;
    wp = 0;
    dropout = 0;
    unsigned int count = 0;
    ticker.attach_us(tickrec, interval_us);
    WAVFILE_DATA_NUM_CHANNELS(&data) = 1;
    while (1) {
        while (rp == wp) {
            wait_us(1);
        }

        WAVFILE_DATA_CHANNEL_DATA(&data, 0) = buffer[rp];
        rp = (rp + 1) & (RAM_TOTAL - 1);
        WAVFILE_ERROR_PRINT(wavfile_write_data(wf, &data));

        count++;
        if (count > samples_for_nsec) {
            break;
        }
    }
    ticker.detach();
    led_rec_ok = 0;
    printf("\t-- Rec done. (dropout=%d) --\r\n", dropout);

    WAVFILE_ERROR_PRINT(wavfile_close(wf));
    return 0;
}



int main(void)
{
    //printf("\r\n\r\n");
    //printf("=======================================================\r\n");
    //printf(" A simple wave recorder & player on mbed               \r\n");
    //printf(" Copyright(C) 2012 Shinichiro Nakamura (CuBeatSystems) \r\n");
    //printf("=======================================================\r\n");

    ticker.attach_us(tickdummy, 100);
    wait(1);
    ticker.detach();

    static const char *target_filename = "/fs/rec-test.wav";
    
    while (1) {
    
        if (record == 1) {
            /* 
             * generate data 
             */
             
            genOn = 1;
            printf("gen/rec on\n");
            tickgenerate.attach_us(tickgen, 10);
            rec(target_filename, 10);
            tickgenerate.detach();
            printf("gen/rec off\n");
        }
        
        if (playback == 1) {
        
            /*
             * Play it!
             */
            printf("play on\n");
            if (play(target_filename) != 0) {
                break;
            }
            printf("play off\n");
        }
    }

    return 0;
}
