#include "mbed.h"
#include "DCMotor.h"
#include "LeftServoMotor.h"
#include "RightServoMotor.h"
#include "Keypad.h"
#include "GlobalObjects.h"
#include "RequestQueue.h"
 
DigitalOut myled(LED1);
InterruptIn irInput(p14);
Timer irTimer;

void moveForward (){
    dcMotor.forward();
    movingDirection = 1;
    irFlag = 1;
}

void moveReverse(){
    dcMotor.reverse();
    movingDirection = -1;
    irFlag = 1;
}

void floorChosen (int i){
    pc.printf(":  %d floor is chosen  :",i);
    queue.add(i);
    if(!dcMotor.isMoving()){
        if(i == currentFloor){  
            floorReached(i);
        }else if(i>currentFloor){
            moveForward();
        }else{
            moveReverse();
        }
    }
}
    
void doStopOperation (){
    dcMotor.stop();
    leftDoor.open();
    rightDoor.open();
    wait(1);
    leftDoor.close();
    rightDoor.close();
} 
 
void floorReached (int i){
    doStopOperation();
    queue.remove(i);
    if(movingDirection == 1){
        if(queue.isForwardRequested(i)){
            moveForward();
        }else if(queue.isReverseRequested(i)){
            moveReverse();
        }else{
            movingDirection = 0;
        }
    }else{
        if(queue.isReverseRequested(i)){
            moveReverse();
        }else if(queue.isForwardRequested(i)){
            moveForward();
        }else{
            movingDirection = 0;
        }
    }
}

void floorDetected (int i){
    currentFloor = i;
    if(queue.isRequested(i))
        floorReached(i);
    else{
        irFlag = 1;
        if(i == 1 && movingDirection == -1){
            dcMotor.stop();
            if(queue.isForwardRequested(i)){
                dcMotor.forward();
            }
        }else if(i==5 && movingDirection == 1){
            dcMotor.stop();
            if(queue.isReverseRequested(i)){
                dcMotor.reverse();
            }
        }
    }
}

int calculateFloor (float timePeriod){
    float f = 1/timePeriod;
    //pc.printf("In calculateFloor %f",f);
    if (f <120.0 && f >80.0){
        return 1;
    }else if (f <220.0 && f >180.0){
        return 2;
    }else if (f <320.0 && f >280.0){
        return 3;
    }else if (f <420.0 && f >380.0){
        return 4;
    }else if (f <520.0 && f >480.0){
        return 5;
    }else
        return 0;
}


int isFirstRise = 1;
void irRise(){
    //pc.printf("Interrupt detected: %d",irFlag);
    if(irFlag){
        if(isFirstRise){
            irTimer.start();
            isFirstRise = 0;
        }else{
            irTimer.stop();
            currentFloor = calculateFloor(irTimer.read());
            if(currentFloor){
                irFlag = 0;
                floorDetected(currentFloor);
            }
            irTimer.reset();    
            isFirstRise = 1;
        }
    }
}

int main() {
    initializeKeypad();
    irInput.rise(&irRise);
    while(1) {
       myled = 1;
       wait(1);
       myled = 0;
       wait(1);
    }
}