#include "mbed.h"

#ifndef REQUESTQUEUE_H
#define REQUESTQUEUE_H

class RequestQueue {
  
private :  
    int floorRequests[5];
public :
    RequestQueue() {
        for(int i=0;i<5;i++)
            floorRequests[i] = 0;
    }
    
    void add(int);
    void remove(int);  
    int isRequested (int);
    int isForwardRequested (int);
    int isReverseRequested (int);
};

void RequestQueue::add (int i){
    //pc.printf(":  %d is requested  :",i);
    floorRequests[i-1] = 1;
}

void RequestQueue::remove (int i){
    floorRequests[i-1] = 0;
}

int RequestQueue::isRequested (int i){
    return floorRequests[i-1];
}

int RequestQueue::isForwardRequested (int i){
    for(int j = i; j<5; j++){
        if(floorRequests[j] == 1)
            return 1;
    }
    return 0;
}

int RequestQueue::isReverseRequested (int i){
    for(int j = 0; j<i-1; j++){
        if(floorRequests[j] == 1)
            return 1;
    }
    return 0;
}

#endif