#include "mbed.h"
#include "GlobalObjects.h"

#ifndef KEYPAD_H
#define KEYPAD_H

//selection pin
volatile int index = 1;

//Row pins
InterruptIn inputOne(p8);
InterruptIn inputTwo(p7);
InterruptIn inputThree(p6);
InterruptIn inputFour(p5);

//Coloumn pins
DigitalOut outputOne(p9);
DigitalOut outputTwo(p10);
DigitalOut outputThree(p11);
DigitalOut outputFour(p12);

//Timer to scan
Ticker  keypadTicker ;
float scanInterval = 0.004; //4ms

void changeConfiguration();

void keyPressed (char ch){
    pc.printf(": %c is pressed :",ch);
    //fflush(stdout);
    switch(ch){
        case '1': floorChosen(1); break;
        case '2': floorChosen(2); break;
        case '3': floorChosen(3); break;
        case '4': floorChosen(4); break;
        case '5': floorChosen(5); break;
        default: break;
    }
}

void keyOnePressed (){
    keypadTicker .detach();
     if (index == 1)
        keyPressed('1');
        //pc.printf(":   1 is pressed   :");
    else if (index == 2)
        keyPressed('4');
        //pc.printf(":   4 is pressed   :");
    else if (index ==3)
        keyPressed('7');
        //pc.printf(":   7 is pressed   :");
    else if (index ==4)
        keyPressed('*');
        //pc.printf(":   * is pressed   :");      
}

void keyOneReleased (){
   keypadTicker .attach(&changeConfiguration,scanInterval);
}
    
void keyTwoPressed (){
   keypadTicker .detach();
    if (index == 1)
        keyPressed('2');
        //pc.printf(":   2 is pressed   : );
    else if (index == 2)
        keyPressed('5');
        //pc.printf(":   5 is pressed   :");
    else if (index ==3)
        keyPressed('8');
        //pc.printf(":   8 is pressed   :");
    else if (index ==4)
        keyPressed('0');
        //pc.printf(":   0 is pressed   :");      
}

void keyTwoReleased (){
   keypadTicker .attach(&changeConfiguration,scanInterval);
}
    
void keyThreePressed (){
   keypadTicker .detach();
   if (index == 1)
        keyPressed('3');
        //pc.printf(":   3 is pressed   :");
    else if (index == 2)
        keyPressed('6');
        //pc.printf(":   6 is pressed   :");
    else if (index ==3)
        keyPressed('9');
        //pc.printf(":   9 is pressed   :");
    else if (index ==4)
        keyPressed('#');
        //pc.printf(":   # is pressed   :");       
}

void keyThreeReleased (){
    keypadTicker .attach(&changeConfiguration,scanInterval);
    }

void keyFourPressed (){
   keypadTicker .detach();
    if (index == 1)
        keyPressed('A');
        //pc.printf(":   A is pressed   :");
    else if (index == 2)
        keyPressed('B');
        //pc.printf(":   B is pressed   :");
    else if (index ==3)
        keyPressed('C');
        //pc.printf(":   c is pressed   :");
    else if (index ==4)
        keyPressed('D');
        //pc.printf(":   D is pressed   :");              
}

void keyFourReleased (){
    keypadTicker .attach(&changeConfiguration,scanInterval);
}

void changeConfiguration(){
    index =index +1;
    if(index == 5)
        index = 1;
    switch (index )
    {
        case 1: 
            outputOne = 0;
            outputTwo = 1;
            outputThree = 1;
            outputFour = 1;
            break;
        case 2:
            outputOne = 1;
            outputTwo = 0;
            outputThree = 1;
            outputFour = 1;
            break;
        case 3:
            outputOne = 1;
            outputTwo = 1;
            outputThree = 0;
            outputFour = 1;
            break;
        case 4:
            outputOne = 1;
            outputTwo = 1;
            outputThree = 1;
            outputFour = 0;
            break;
        default : break;
    }    
}

void initializeKeypad(){
    outputOne = 1;
    outputTwo = 1;
    outputThree = 1;
    outputFour = 1;
    inputOne.fall(&keyOnePressed);
    inputOne.rise(&keyOneReleased);
    inputTwo.fall(&keyTwoPressed);
    inputTwo.rise(&keyTwoReleased);
    inputThree.fall(&keyThreePressed);
    inputThree.rise(&keyThreeReleased);
    inputFour.fall(&keyFourPressed);
    inputFour.rise(&keyFourReleased);
    keypadTicker.attach(&changeConfiguration, scanInterval);
}

#endif