#include "mbed.h"
 
#ifndef DCMOTOR_H
#define DCMOTOR_H
 
class DCMotor {
    
private:
    PwmOut ePin;
    DigitalOut fPin, rPin;
    
public:
    DCMotor (PinName ePin_, PinName fPin_, PinName rPin_) : ePin(ePin_), fPin(fPin_), rPin(rPin_){ ePin.period(0.020);ePin = 0;}
       
    void forward();        
    void stop();
    void reverse();
    int isMoving();
};
 
void DCMotor::forward(){
    fPin = 1;
    rPin = 0;
    ePin = 0.2f;
}
 
void DCMotor::stop(){
    fPin = rPin = 0;
    ePin = 0.0;
}
 
void DCMotor::reverse(){
    fPin = 0;
    rPin = 1;
    ePin = 0.2f;
}

int DCMotor::isMoving(){
    if(ePin == 0.0)
        return 0;
    return 1;
}

#endif