#include "mbed.h"
#include "C12832.h"
#include "MMA7660.h"

// Using Arduino pin notation
C12832 lcd(D11, D13, D12, D7, D10);
MMA7660 MMA(D14,D15);
DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
DigitalIn right(A5);
DigitalIn fire(D4);

// main() runs in its own thread in the OS
int main() {
    float x = 0, y = 0, threshold = 0.25;
    //float temp_x, temp_y;
    int loc_x = 0, loc_y = 0;
    lcd.locate(0, 0);
    while (true) {
        lcd.cls();
        /*temp_x = MMA.x();
        if(temp_x > x + threshold) {
            x = temp_x;
            if(loc_y > 0)
                loc_y--;
        }
        else if(temp_x < x - threshold) {
            x = temp_x;
            if(loc_y < 32)
                loc_y++;
        }
        temp_y = MMA.y();
        if(temp_y > y + threshold) {
            y = temp_y;
            if(loc_x > 0)
                loc_x--;
        }
        else if(temp_y < y - threshold) {
            y = temp_y;
            if(loc_x < 128)
                loc_x++;
        }*/
        
        x = MMA.x();
        y = MMA.y();
        if(x > threshold) {
                loc_y--;
        }
        else if(x < -1 * threshold) {
                loc_y++;
        }
        if(y > threshold) {
                loc_x--;
        }
        else if(y < -1 * threshold) {
                loc_x++;
        }
        if(loc_y > 32)  loc_y = 32;
        else if(loc_y < 0)   loc_y = 0;
        if(loc_x > 128) loc_x = 128;
        else if(loc_x < 0)   loc_x = 0;
        lcd.circle(loc_x, loc_y, 2, 1);
        wait(0.01);
    }
}

