#include "mbed.h"
#include "dsp.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
Timer tim;

int main() {
    unsigned int i = 0;
    
    q15_t lad[5], ref[6];
    q15_t state[1029], in[1024], out[1024];
    // this loop takes 4 assembly instructions to run per cycle
    // http://www.wolframalpha.com/input/?i=%282731+us%2F65536%29%2F%281%2F24000000Hz%29
    arm_iir_lattice_instance_q15 filter = {5, state, ref, lad};
    tim.start();
    while (i<100) 
    {
        arm_iir_lattice_q15(&filter, in, out, 1024);
        i++;
    }
    tim.stop();
    pc.printf("%d us\n\r",tim.read_us());
}
//mbed LPC1768 runs at 96 MHz
//2731 us=65536 cycles