#pragma once

#include "mbed.h"

Serial PC(USBTX, USBRX);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

class IMU{
    public:
        IMU(int baud, PinName tx, PinName rx, Serial* pc);
        ~IMU();
        
        void getData();
        void attach(void (*fptr)(void));
        void putc(char c);
        //void readIMU();
        short accX, accY, accZ, gyrX, gyrY, gyrZ, magX, magY, magZ;
        bool readable;
        bool newData;
        
    private:
        Serial* p_device;
        Serial* p_pc;
        inline void makeCorrect(short* i);
        void parse();
        
        int i_IMU;
        char bufIMU[21];
} imu(57600, p9, p10, &PC);

void readIMU();
