/*
 * Demo that communicates with the MiniSSC 2. This also works with the Pololu Mini Maestro.
 */

#include "mbed.h"
#include "minissc.h"

// MiniSSC2's Constructor
MiniSSC2::MiniSSC2(int num_motors, int baud, PinName tx, PinName rx) {
    this->num_motors = num_motors;
    p_device = new Serial(tx, rx); // (tx, rx) opens up new serial device (p_device is Serial* pointer)
    p_device->format(8, Serial::None, 1);
    p_device->baud(baud); // Set the baud.
    set(127);   // The motors should start stationary (zero power)
}

// MiniSSC2's Destructor
MiniSSC2::~MiniSSC2() {
    if (p_device != NULL) {
        // must do this. otherwise, you'll have memory leakage & you may not be able to re-open the serial port later
        delete p_device;
    }
}

void MiniSSC2::send() {
    for (int i = 0; i < num_motors; i++) {
        send(i);
    }
}

void MiniSSC2::send(int i_motor) {
    // format: {sync byte, motor id, motor power}
    // example: {SSC_SYNC_BYTE, 2, 24} sets motor 2 to power level 24
    p_device->putc(SSC_SYNC_BYTE);
    p_device->putc((unsigned char)i_motor);
    p_device->putc(motors[i_motor]);
}

void MiniSSC2::set(unsigned char value) {
    for (int i = 0; i < num_motors; i++) {
        set(i, value);
    }
}

void MiniSSC2::set(int i_motor, unsigned char value) {
    motors[i_motor] = value;
}

unsigned char MiniSSC2::get(int i_motor) {
    return motors[i_motor];
}

void ssc_send_cb() {
    PC.printf("Sent (callback)\n");
    ssc.send(); // is there a more efficient way to do this?
}

void led1_on_cb()
{
    led1 = 1;
}

void led1_off_cb()
{
    led1 = 0;
}

/* MAIN FUNCTION */
// this code is very bad. please do not use it for anything serious.
int main() {
    led1 = 1;
    wait_ms(500);
    //ssc_to.attach(&ssc_send_cb, 1); // run ssc_send_cb() at 10 Hz (Ticker) (increase if possible)
    PC.baud(115200);
    PC.printf("\n\r\n\rHello.\n\r");
    
    led1_on.attach(&led1_on_cb, 1.0f);
    wait_ms(50);
    led1_off.attach(&led1_off_cb, 1.0f);
    
        ssc.set(1);
    while (true)
    {
        led2 = led3 = led4 = 0;
        led2 = 1;
        ssc.send();
        /*PC.printf("Motors: l = left, r = right, f = forward, b = back.\n\r");
        PC.printf("Which motor? ");
        int in = PC.getc();
        PC.printf("%c\n\r", in);
        char motorID, motorData;
        PC.printf("Setting motor ");
        switch (in)
        {
            case 'r':
                motorID = 0;
                PC.printf("left.\n\r");
                break;
                
            case 'l':
                motorID = 1;
                PC.printf("right.\n\r");
                break;
            
            case 'f':
                motorID = 2;
                PC.printf("front.\n\r");
                break;
            
            case 'b':
                motorID = 3;
                PC.printf("back.\n\r");
                break;
                
            case 'q':
                ssc.set(127);
                ssc.send();
                break;
                
            default:
                PC.printf("Invalid motor. Try again.\n\r");
                continue;
                break;
        }
        led3 = 1;
        PC.printf("Power (-100 to 100): ");
        std::string powerRaw;
        tryAgain:
        powerRaw.clear();
        while (true)
        {
            in = PC.getc();
            PC.putc(in);
            led4 = 1;
            if (in == '\r')
            {
                PC.putc('\n');
                break;
            }
            powerRaw.push_back(in);
        }
        
        if (sscanf(powerRaw.c_str(), "%d", &in) < 1 || in > 100 || in < -100)
        {
            printf("Invalid power. Try again: ");
            goto tryAgain;
        }
        
        in *= 1.27f;
        in += 127;
        
        //PC.printf("Set motor %d to %d\n\r\n\r", motorID, in);
        
        ssc.set(motorID, in);
        ssc.send(motorID);
        
        PC.printf("\n\r--------------------------------\n\r");*/
    }
}
