#pragma once

#include "mbed.h"
#include <string>
#include <sstream>

#define SSC_SYNC_BYTE 255

// Stores values for and communicates with the Mini SSC II. This is used to control the motors and move the sub.
class MiniSSC2 {
public:
    MiniSSC2(int num_motors, int baud, PinName tx, PinName rx);
    ~MiniSSC2();
    void send(); // send all motors' speeds to the Mini SSC II
    void send(int i_motor); // send speed of motor i_motor to the Mini SSC II
    void set(unsigned char value); // set, but don't send, all the motors to a single value
    void set(int i_motor, unsigned char value); // set, but don't send, motor number i_motor to value
    unsigned char get(int i_motor); // get the current speed for motor number i_motor
private:
    Serial* p_device; // pointer to our serial object (used to send stuff)
    int num_motors; // number of motors, counting from 1
    
    /*
     * These arrays send input to the Mini SSC II which in turn sends to the motors. 
     * The format for the arrays: {SYNC_BYTE, servo number, speed}
     * SYNC_BYTE tells the Mini SSC II that we're about to send new instructions.
     * The servo number picks the motor. 1 = right, 2 = back, 3 = front, 4 = left
     * We set the speed anywhere between 0 and 254. 127 is off, 254 is 100% forward, 0 is 100% back.
     * On the back motor, the numbers are reversed. 0 is 100% forward, 254 is 100% back. 127 is still off.
     * The speed scales approximately linearly with the set values, though there is no motor motion until around 127+-15.
     */
     
     //The Mini SSC II supports 8 motors. The Pololu supports 12. This array locally stores their speeds.
     unsigned char motors[24];
};

void ssc_send_cb();
MiniSSC2 ssc(4, 9600, p13, p14); // 4 motors, baud for Mini SSC II is 9600, Mini SSC II is connected to pins 9 and 10
Ticker ssc_to;

Ticker led1_on, led1_off;

// debug
Serial PC(USBTX, USBRX); // tx, rx
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);