#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"

AnalogIn Vin(PTC2);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7

AnalogIn y(PTB0);
AnalogOut u(PTE30);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalIn button1(PTC12);
DigitalIn button2(PTC13);
DigitalIn button3(PTC16);
DigitalIn button4(PTC17);


//codigos movimiento del curzor

//int C1=0x0E; // solo muestra el curzor
int C2=0x18; // desplaza izquierda
int C3=0x1A; // desplaza derecha
int C4=0x0C; // quito cursor bajo

int C1=0x0F;
int err, med, yr, pid, ap, ai, ad, err_v, cycle;
float pidn;
int spnum=0,kinum=0,kpnum=0,kdnum=0,pos=1;
int incremento=1,flagt=0;
Timer t;

int main()
{
    lcd.cls(); // Borrar Pantalla
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD

    lcd.locate(8,0);
    lcd.printf("Kp=%d",kpnum);
    lcd.locate(0,1);
    lcd.printf("Ki=%d",kinum);
    lcd.locate(8,1);
    lcd.printf("Kd=%d",kdnum);
    lcd.locate(0,0);
    lcd.printf("Sp=%d",spnum);

    while(1)
    {
        if (!button1)
        {
            if(flagt==0)
            {
                t.start();
                flagt=1;
            }

            led1 =!led1;
            wait(0.25);
            if(!button1)
            {
                if(t.read()>5)
                {
                    incremento=100;
                }
                else if(t.read()>2.75)
                {
                    incremento=10;
                }

                if(pos==1)
                {
                    if(spnum+incremento>=999)
                    {
                        spnum=999;
                        lcd.locate(3,0);
                        lcd.printf("    ");
                        lcd.locate(3,0);
                        lcd.printf("%d", spnum);
                    }
                    else
                    {
                        spnum+=incremento;
                        lcd.locate(3,0);
                        lcd.printf("%d", spnum);
                    }
                }
                else if(pos==2)
                {
                    if(kpnum+incremento>=999)
                    {
                        kpnum=999;
                        lcd.locate(11,0);
                        lcd.printf("    ");
                        lcd.locate(11,0);
                        lcd.printf("%d", kpnum);
                    }
                    else
                    {
                        kpnum+=incremento;
                        lcd.locate(11,0);
                        lcd.printf("%d", kpnum);
                    }
                }
                else if(pos==3)
                {
                    if(kinum+incremento>=999)
                    {
                        kinum=999;
                        lcd.locate(3,1);
                        lcd.printf("    ");
                        lcd.locate(3,1);
                        lcd.printf("%d", kinum);
                    }
                    else
                    {
                        kinum+=incremento;
                        lcd.locate(3,1);
                        lcd.printf("%d", kinum);
                    }
                }
                else if(pos==4)
                {
                    if(kdnum+incremento>=999)
                    {
                        kdnum=999;
                        lcd.locate(11,1);
                        lcd.printf("    ");
                        lcd.locate(11,1);
                        lcd.printf("%d", kdnum);
                    }
                    else
                    {
                        kdnum+=incremento;
                        lcd.locate(11,1);
                        lcd.printf("%d", kdnum);
                    }
                }
            }
        }

        if (!button2)
        {
            if(flagt==0)
            {
                //t.reset();
                t.start();
                flagt=1;
            }

            led1 =!led1;
            wait(0.25);
            if(!button2)
            {
                if(t.read()>5)
                {
                    incremento=100;
                }
                else if(t.read()>2.75)
                {
                    incremento=10;
                }

                led2 =!led2;
                if(pos==1)
                {
                    if(spnum-incremento<0)
                    {
                        //No ocurre nada
                    }
                    else
                    {
                        spnum-=incremento;
                        lcd.locate(3,0);
                        lcd.printf("    ");
                        lcd.locate(3,0);
                        lcd.printf("%d", spnum);
                    }
                }
                else if(pos==2)
                {
                    if(kpnum-incremento<0)
                    {
                        //No ocurre nada
                    }
                    else
                    {
                        kpnum-=incremento;
                        lcd.locate(11,0);
                        lcd.printf("    ");
                        lcd.locate(11,0);
                        lcd.printf("%d", kpnum);
                    }
                }
                else if(pos==3)
                {
                    if(kinum-incremento<0)
                    {
                        //No ocurre nada
                    }
                    else
                    {
                        kinum-=incremento;
                        lcd.locate(3,1);
                        lcd.printf("    ");
                        lcd.locate(3,1);
                        lcd.printf("%d", kinum);
                    }
                }
                else if(pos==4)
                {
                    if(kdnum-incremento<0)
                    {
                        //No ocurre nada
                    }
                    else
                    {
                        kdnum-=incremento;
                        lcd.locate(11,1);
                        lcd.printf("    ");
                        lcd.locate(11,1);
                        lcd.printf("%d", kdnum);
                    }
                }
            }
        }

        if (!button3)
        {
            led3 =!led3;
            if(pos==4)
            {
                pos=1;
                lcd.locate(3,0);
                lcd.printf("%d", spnum);
            }
            else if (pos==1)
            {
                pos++;
                lcd.locate(11,0);
                lcd.printf("%d", kpnum);
            }
            else if(pos==2)
            {
                pos++;
                lcd.locate(3,1);
                lcd.printf("%d", kinum);
            }
            else if(pos==3)
            {
                pos++;
                lcd.locate(11,1);
                lcd.printf("%d", kdnum);
            }
            wait(0.25);

        }

        if (button1 && button2)
        {
            flagt=0;
            t.reset();
            incremento=1;
        }
        if (!button4)
        {
            break;     //sale del bucle si pisan suiche4
        }
    }


    //Transicion
    lcd.writeCommand(C4);//escribimos un comando segun el manual del modulo LCD para quitar cursor bajo
    lcd.cls(); //borra la pantalla
    lcd.printf("   GUARDADOS!");
    wait(1);
    lcd.cls();
    lcd.printf(" INICIA EL PID");
    wait(1);
    // se imprimen los parches del control  *****************************************
    lcd.cls();
    lcd.printf("Er=%d",err);
    lcd.locate(8,0);
    lcd.printf("Me=%d",med);
    lcd.locate(0,1);
    lcd.printf("Sp=%d",spnum);
    lcd.locate(8,1);
    lcd.printf("Co=%d",pid);
    wait(2);

    // CICLO PRINCIPAL CONTROLADOR PID
    flagt=0;
    while(1)
    {
        med=999*y.read();   //leer puerto analogo y asignar a med
        err = (spnum-med);  //se calcula el error

        ap = kpnum*err;     //se calcula la accion proporcinal

        // se verifica que la accion integral no sea muy grande
        if(ai<100)
        {
            ai =(kinum*err)+ai;    //calculo de la integral del error
        }

        ad = kdnum*(err-err_v); //calculo de la accion derivativa

        pid = (ap+ai+ad);

        // se verifica que pid sea positivo **************************************
        if(pid<=0)
        {
            pid=0;
        }

        // se verifica que pid sea menor o igual la valor maximo *****************
        if (pid > 999)
        {
            pid=999;
        }

        // se actualizan las variables *******************************************
        err_v = err;

        //se muestran las variables******************************************
        if(flagt==0)
        {
            t.start();
            flagt=1;
        }
        if(t>=0.3)
        {
            lcd.locate(3,0);lcd.printf("    ");
            lcd.locate(3,0);lcd.printf("%d",err);
            lcd.locate(11,0);lcd.printf("    ");
            lcd.locate(11,0);lcd.printf("%d",med);
            lcd.locate(3,1);lcd.printf("    ");
            lcd.locate(3,1);lcd.printf("%d",spnum);
            lcd.locate(11,1);lcd.printf("    ");
            lcd.locate(11,1);lcd.printf("%d",pid);
            flagt=0;
            t.reset();
        }

        //Normalizacion de la salida
        pidn=pid/999;
        //  se envia el valor pid a puerto analogico de salida (D/A) **************
        u.write(pidn);
        //  se repite el ciclo
        wait(0.005);
    }

}
