#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "SDFileSystem.h"

RawSerial blue(p28,p27);
uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
DigitalOut led1(LED1);
Thread thread;
Thread threadA;
Thread threadB;
Thread threadC;
//Thread threadD;
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);
Mutex stdio_mutex;
DigitalOut latch(p15);
DigitalOut enable(p16);
SPI spi(p11, p12, p13);
volatile int flag = 0;
char bnum = 0;


void RGB_LED(int red, int green, int blue) {
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}

void threadBT(){
    while(1) {
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data
                bnum = blue.getc(); //button number
                if ((bnum=='4')){ //is a number button 1..4
                    uLCD.cls(); //turn on/off that num LED
                    uLCD.printf("HELLO BT!");}
            }
        }
    }
    }

void thread1(){
    while(true) {
        
        stdio_mutex.lock();
        uLCD.cls();
        uLCD.printf("Pink Panther");
        uLCD.text_width(2);
        uLCD.text_height(4);
        uLCD.color(RED);
        Thread::wait(1000);
        uLCD.cls();
            stdio_mutex.unlock();
            
    }
    }
    
void thread2(){
    FILE *wave_file;
    printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/mydir/sdtest.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
    }

void thread3(){
 
 int red=0;
    int green=0;
    int blue=0;
    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;
    wait(2);
    for (red = 0; red<50; red = red+10) {
        for (blue = 0; blue<50; blue = blue+10) {
            for (green = 0; green<50; green = green+10)
 
            {
                RGB_LED( red, green, blue);
                wait(.25);
            }
        }
    }

    }
    

int main()
{    
    thread.start(thread1);
    threadA.start(thread2);
    threadB.start(thread3);
    threadC.start(threadBT);
  //  threadD.start(threadBT2);
     set_time(1570189620);  // Set RTC time to Fri, 4 Oct 2019 11:47:00
   
 
    while (true) {
    
        stdio_mutex.lock();
        
        time_t seconds = time(NULL);
        
        //uLCD.printf("Time as seconds since January 1, 1970 = %d\n", seconds);
                  
    uLCD.cls();
        uLCD.printf("Time is : %s", ctime(&seconds));
        uLCD.text_width(2);
        uLCD.text_height(4);
        uLCD.color(RED);
        
 
        char buffer[32];
        strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        //uLCD.printf("Time as a custom formatted string = %s", buffer);
        
        wait(5);
        uLCD.cls();
                    stdio_mutex.unlock();



}
    }

    
    
    
    
    
    
    