#include "mbed.h"
#include "TB6612FNG.h"
#include "SDFileSystem.h"
#include "rtos.h"
 
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
Thread thread;
// -------------------taken pins--------------------------------
//5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,_,27,28,29,30
// -------------------------------------------------------------

//direction pins
DigitalOut idir1(p9);
DigitalOut idir2(p10);
DigitalOut i2_dir1(p27);
DigitalOut i2_dir2(p28);
DigitalOut i3_dir1(p30);
DigitalOut i3_dir2(p17);

//in Thread thread;
DigitalOut wc_dir1(p29); //SOLDER
DigitalOut wc_dir2(p20); //SOLDER

DigitalOut wc1_dir1(p12); //SOLDER
DigitalOut wc1_dir2(p13); //SOLDER

//pushbutton to stop program execution
DigitalIn pb(p29);

//pwm out to motors
PwmOut ipwm(p21);
PwmOut i2_pwm(p22);
PwmOut i3_pwm(p23);

//in Thread thread;
PwmOut wc_in_pwm(p24);
PwmOut wc_out_pwm(p25);

//standby pins
DigitalOut istdby(p11);
DigitalOut set2_istdby(p18);
DigitalOut wc_istdby(p14);

//water level sensors
DigitalIn water_level_fw_reservoir(p15);
DigitalIn water_level_display_tank(p16);
DigitalIn salt_mix_reservoir(p19);

//flow rate (L/ # of days)
float flow_rate_L_num_days = 40;

//timespan (# of days)
int days = 1;
int sec_days = days * 86400;

//vol of 2s pump (L)
float two_s_pump_volume_L = 0.05;

//pc serial connection
Serial pc(USBTX, USBRX); // tx, rx

//motors in main thread
TB6612FNG fw_reservoir_to_display_tank(p27, p28, p22, p11);
TB6612FNG source_to_fw_reservoir(p9, p10, p21, p11);
TB6612FNG fw_reservoir_to_salt_mix_reservoir(p30, p17, p23, p18);

//motors in Thread thread;
TB6612FNG water_change_in(p29, p20, p24, p18);
TB6612FNG water_change_out(p12, p13, p25, p14);

//Motor Pins
//TB6612FNG motor(PinName idir1, PinName idir2, PinName ipwm, PinName istby);



void water_change(){
    
    time_t start = time(NULL);
    
  //  float flow_rate_L_num_days = 40;
   // float two_s_pump_volume_L = 0.05;
    int pumps_per_num_days = flow_rate_L_num_days / two_s_pump_volume_L;
    int total_wait_time = sec_days - (pumps_per_num_days * 2); 
    int wait_bw_pump = total_wait_time / pumps_per_num_days;
    
    pc.printf("delay bw pumps in seconds: %d\n", wait_bw_pump);
    
    source_to_fw_reservoir.start(); 
    water_change_in.start(); 
    water_change_out.start(); 
    
    while(time(NULL) - start < sec_days) {
        
        water_change_in.fwd(1); 
        water_change_out.fwd(1);
    
        wait(wait_bw_pump);
    
        }
 
    water_change_in.stop(); 
    water_change_out.stop();
 
    }
    

int main() {
        
    thread.start(water_change);
    
        pb.mode(PullUp);
        int count = 0;
        int count2 = 0;
        int count3 = 0;
         
         mkdir("/sd/mydir", 0777);
    
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    } 
    
    time_t start = time(NULL);
    fprintf(fp, "Start Time: %d\n", start);

    
    while(pb != 0) { //push button not pressed.  pb != 0
        //pc.printf("%d \n", test);
      //////////////////////////////////////////////
        int val = water_level_fw_reservoir.read();
        
        source_to_fw_reservoir.start(); 
                
        
        while(val == 1) { //air detected
        val = water_level_fw_reservoir.read(); 
        source_to_fw_reservoir.fwd(1); 
        fprintf(fp, "SOURCE TO FWR #%d\n", count);
                time_t program_seconds = time(NULL);
                fprintf(fp, "Latest measurement time: %d\n", program_seconds);
        wait(2);
        count++;
            }
            
        source_to_fw_reservoir.stop();
   ///////////////////////////////////////////////////////
   int val2 = water_level_display_tank.read(); //read display tank water level
        
        
        
        fw_reservoir_to_display_tank.start(); //pump start
        
        
        if(val2 == 1) { //air detected (needs water)
        fprintf(fp, "FWR TO DSPLY TANK #%d\n", count2);
        time_t program_seconds = time(NULL);
        fprintf(fp, "Latest measurement time: %d\n", program_seconds);
        fw_reservoir_to_display_tank.fwd(1); //power pump forward
        count2++;
        wait(2);
            }
        
        fw_reservoir_to_display_tank.stop(); 
        
        ///////////////////////////////////////////////////////
   int val3 = salt_mix_reservoir.read(); //read display tank water level
        
        
        
        fw_reservoir_to_salt_mix_reservoir.start(); //pump start
        
        
        if(val3 == 1) { //air detected (needs water)
        fprintf(fp, "FWR TO SLT MX RVR #%d\n", count3);
        time_t program_seconds = time(NULL);
        fprintf(fp, "Latest measurement time: %d\n", program_seconds);
        fw_reservoir_to_salt_mix_reservoir.fwd(1); //power pump forward
        count3++;
        wait(2);
            }
        
        fw_reservoir_to_salt_mix_reservoir.stop(); 
         
    
    }
    
  fclose(fp); //close sd filesystem
}
