/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <anthony.harivel@gmail.com> wrote this file. As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return 
 * ----------------------------------------------------------------------------
 */
 
#include "mbed.h"

Serial pc(USBTX,USBRX); //enable serial connection

InterruptIn dcfPinIn (PTD7); //connection to non inverting output of dcf module

Timer r,f; //create two timers

int count; //count the received info per minutes

int dcf_array[60]; //array of the dcf77 info

// boolean for Rising and falling edge
volatile bool bRise = false;
volatile bool bFall = false;

// when we got a rising edge...
void riseInt()
{
    f.stop();
    r.reset();
    r.start();
    bFall = true;
}

// when we got a falling edge...
void fallInt()
{
    r.stop();
    f.reset();
    f.start();
    bRise = true;
}

// simple dcf77 information print function.
void print_time()
{   
    int hour, min, day, month, year;
    
    //calculate hour--------------------------------------------------------------------------------------
    hour = dcf_array[34] * 20 + dcf_array[33] * 10 + dcf_array[32] * 8 + dcf_array[31] * 4 + dcf_array[30] * 2 + dcf_array[29] * 1;
    
    //calculate minutes------------------------------------------------------------------------------------
    min = dcf_array[24] * 8 + dcf_array[23] * 4 + dcf_array[22] * 2 + dcf_array[21] * 1 + dcf_array[27] * 40 + dcf_array[26] * 20 +dcf_array[25] * 10;
    
    //calculate day----------------------------------------------------------------------------------------
    day = dcf_array[39] * 8 + dcf_array[38] * 4 + dcf_array[37] * 2 + dcf_array[36] * 1 + dcf_array[41] * 20 + dcf_array[40] * 10;
    
    //calculate month--------------------------------------------------------------------------------------
    month = dcf_array[49] * 10 + dcf_array[48] * 8 + dcf_array[47] * 4 + dcf_array[46] * 2 + dcf_array[45] * 1;
    
    //calculate year---------------------------------------------------------------------------------------
    year = dcf_array[57] * 80 + dcf_array[56] * 40 + dcf_array[55] * 20 + dcf_array[54] * 10 + dcf_array[53] * 8 +dcf_array[52] * 4 + dcf_array[51] * 2 + dcf_array[50] * 1;
    
    pc.printf("%dh%dmin %d/%d/%d \r\n", hour, min, day, month, year);
}

// main //
int main()
{
    // attach two functions:
    // 1 for the falling edge
    // 1 for the rising edge
    dcfPinIn.rise(&riseInt);
    dcfPinIn.fall(&fallInt);
    
    // endless loop
    while(1)
    {
        ///////////////////////////
        if( bFall == true )
        {
            // did we pass the reset time ?
            if( f.read_ms() > 950 )
            {
                //pc.printf("reset");
                print_time();
                count = 0;
            }
            else
            {
                pc.printf(".");
            }
            
            bFall = false;
        } //if bFall
        
        //////////////////////////    
        if( bRise == true )
        {
            // 100ms = '0' and 200ms = '1' 
            if( r.read_ms() > 150 )
            {
              //pc.printf("1");
              dcf_array[count] = 1;
            }
            else
            {
              //pc.printf("0");
              dcf_array[count] = 0;
            }
            
            count ++;
            bRise = false;
        }//if bRise
            
    } // while
} // main


