#ifndef NAVIGATOR_H
#define NAVIGATOR_H

#include "mbed.h"
#include "Menu.h"
#include "TextLCD.h"
#include "RPG.h"

class Navigator {   
    private: 
               
    public:
        Navigator(Menu *, RPG &, TextLCD *);
        Menu *activeMenu; // the current menu - can change when RPG is pushed on selection with child menu
        RPG rpg;
        TextLCD *lcd; 
        
        bool lastButton, button;
        int direction;  // 1 = CW, -1 = CCW
        
        int bottom;     // the index of the last item of current menu
        int cursorPos;  // what selection the cursor points to
        int cursorLine; // what line of the lcd the cursor is on. 1 = first line, 2 = second line
        
        void poll();    // repeatedly call this function to determine if RPG is being used
        void moveUp();
        void moveDown();
        void printMenu();
        void printCursor();
};

#endif 