#include "Navigator.h"

Navigator::Navigator(Menu *root, RPG &rpg, TextLCD *lcd) : activeMenu(root), rpg(rpg), lcd(lcd) 
{
    bottom = root->selections.size();
    cursorPos = 0;
    cursorLine = 1;
    button = 0;
    lastButton = 0;
    
    printMenu();
    printCursor();
}

void Navigator::printMenu()
{ 
    lcd->cls();
    if(bottom == 1){ // the current Menu only has one selection
        lcd->printf("%s\n", activeMenu->selections[0].selText);
    } else {
        if(cursorLine == 2){ // if we're at the bottom
            lcd->printf("%s\n", activeMenu->selections[cursorPos-1].selText);
            lcd->printf("%s\n", activeMenu->selections[cursorPos].selText);
        } else {
            lcd->printf("%s\n", activeMenu->selections[cursorPos].selText);
            lcd->printf("%s\n", activeMenu->selections[cursorPos+1].selText);
        }
    }
}

void Navigator::printCursor()
{        
    lcd->locate(0,0);
    if(cursorLine == 1){
        lcd->putc('>');
        lcd->locate(0,1);
        lcd->putc(' ');
    } else if(cursorLine == 2){
        lcd->putc(' ');
        lcd->locate(0,1);
        lcd->putc('>');
    }
}

void Navigator::poll()
{
    if((direction = rpg.dir())!=0){ //Get Dir
        wait(0.2); 
        if(direction == 1) moveDown();
        else if(direction == -1) moveUp();
    }
       
    if ((button = rpg.pb()) && !lastButton){ //prevents multiple selections when button is held down
        wait(0.2);
        if(activeMenu->selections[cursorPos].fun != NULL){
            (activeMenu->selections[cursorPos].fun)();
        }
        if(activeMenu->selections[cursorPos].childMenu != NULL){
            activeMenu = activeMenu->selections[cursorPos].childMenu;
            bottom = activeMenu->selections.size();
            cursorPos = 0;
            cursorLine = 1;
            printMenu();
            printCursor();
        }
    }
    lastButton = button;
}

void Navigator::moveUp()
{
    if(cursorLine == 1){
        printMenu();
    } else if(cursorLine == 2){
        cursorLine = 1;
    }
    
    if(cursorPos != 0){
        cursorPos--;
        printMenu();
    }
    printCursor();
}

void Navigator::moveDown()
{
    if(cursorLine == 1){
        cursorLine = 2;
    } else if(cursorLine == 2){
        printMenu();
    }
    
    if(cursorPos != (bottom-1)){
        cursorPos++;
        printMenu();
    }
    printCursor();
}