#ifndef SSD1306_SIMPLE_H
#define SSD1306_SIMPLE_H

#include "mbed.h"
#include "font_8x8.h"
#include "font_16x24.h"
#include "font_16x12.h"

   #define SSD1306_128_64
//   #define SSD1306_128_32
//   #define SSD1306_96_16
/*=========================================================================*/

#if defined SSD1306_128_64 && defined SSD1306_128_32
  #error "Only one SSD1306 display can be specified at once in SSD1306.h"
#endif
#if !defined SSD1306_128_64 && !defined SSD1306_128_32 && !defined SSD1306_96_16
  #error "At least one SSD1306 display must be specified in SSD1306.h"
#endif

#if defined SSD1306_128_64
  #define SSD1306_LCDWIDTH                  128
  #define SSD1306_LCDHEIGHT                 64
#endif
#if defined SSD1306_128_32
  #define SSD1306_LCDWIDTH                  128
  #define SSD1306_LCDHEIGHT                 32
#endif
#if defined SSD1306_96_16
  #define SSD1306_LCDWIDTH                  96
  #define SSD1306_LCDHEIGHT                 16
#endif

#define SSD1306_SETCONTRAST 0x81
#define SSD1306_DISPLAYALLON_RESUME 0xA4
#define SSD1306_DISPLAYALLON 0xA5
#define SSD1306_NORMALDISPLAY 0xA6
#define SSD1306_INVERTDISPLAY 0xA7
#define SSD1306_DISPLAYOFF 0xAE
#define SSD1306_DISPLAYON 0xAF

#define SSD1306_SETDISPLAYOFFSET 0xD3
#define SSD1306_SETCOMPINS 0xDA

#define SSD1306_SETVCOMDETECT 0xDB

#define SSD1306_SETDISPLAYCLOCKDIV 0xD5
#define SSD1306_SETPRECHARGE 0xD9

#define SSD1306_SETMULTIPLEX 0xA8

#define SSD1306_SETLOWCOLUMN 0x00
#define SSD1306_SETHIGHCOLUMN 0x10

#define SSD1306_SETSTARTLINE 0x40

#define SSD1306_MEMORYMODE 0x20
#define SSD1306_COLUMNADDR 0x21
#define SSD1306_PAGEADDR   0x22

#define SSD1306_COMSCANINC 0xC0
#define SSD1306_COMSCANDEC 0xC8

#define SSD1306_SEGREMAP 0xA0

#define SSD1306_CHARGEPUMP 0x8D

#define SSD1306_EXTERNALVCC 0x1
#define SSD1306_SWITCHCAPVCC 0x2

// Scrolling #defines
#define SSD1306_ACTIVATE_SCROLL 0x2F
#define SSD1306_DEACTIVATE_SCROLL 0x2E
#define SSD1306_SET_VERTICAL_SCROLL_AREA 0xA3
#define SSD1306_RIGHT_HORIZONTAL_SCROLL 0x26
#define SSD1306_LEFT_HORIZONTAL_SCROLL 0x27
#define SSD1306_VERTICAL_AND_RIGHT_HORIZONTAL_SCROLL 0x29
#define SSD1306_VERTICAL_AND_LEFT_HORIZONTAL_SCROLL 0x2A


#define DATA_MODE                  0x40


// Display dimensions
#define ROWS                       64
#define COLUMNS                    128
#define PAGES                      (ROWS / 8)
#define MAX_PAGE                   (PAGES - 1)
#define MAX_ROW                    (ROWS - 1)
#define MAX_COL                    (COLUMNS - 1)

// Character dimensions 8x8 font
#define CHARS                      (COLUMNS / FONT8x8_WIDTH)  // = 

// Command and Datamode 
#define COMMAND_MODE               0x80 // continuation bit is set! Just means we could stream cotinous coomands 
                                        // as is done in in triple comand mode


#define SET_COLUMN_ADDRESS         0x21 // takes two bytes, start address and end address of display data RAM
#define SET_PAGE_ADDRESS           0x22 // takes two bytes, start address and end address of display data RAM


#define FRAME_BUF_OFFSET 13

#define FONT_8x8 0
#define FONT_16x12_0 1
#define FONT_16x12_1 2

#define TIMEOUT_INIT 400


class SSD1306 {
    
public:
    SSD1306();

    void writeString(uint8_t col, const char * text) ;
    void writeInt( uint8_t col, int16_t num);
    void WriteRow( uint8_t page );
    void ClearBuf();
    bool IsReady();
    void setFont( uint8_t font );
    
private:
    
    void clearDisplay();
    void ResetI2C();
    bool i2cWrite( uint8_t *buf, uint8_t num_bytes);
    void DMAi2cWrite( uint8_t *buf, uint8_t num_bytes);
    void writeFrameBufRow( uint8_t page );
    void writeCharToBuf( uint8_t col, char chr );
    bool ssd1306_command(uint8_t c);
    void _sendCommand(uint8_t command, uint8_t param1, uint8_t param2);
    void _sendData(uint8_t data);
    void setPageAddress(uint8_t start, uint8_t end);
    void setColumnAddress(uint8_t start, uint8_t end);
    void writeChar(char chr);
    uint8_t framebuf[COLUMNS+FRAME_BUF_OFFSET];   // add control commands. Only a single row is buffered at a time.
    int timeout_cnt;
    
    void SetupFrameBuf();
    uint8_t _char_width;
    uint8_t _font;

};

//char *convert(unsigned int num, int base);



#endif