#include "mbed.h"

#include "fw_config.h"
#include "math_ops.h"
#include "Inverter.h"
#include "ServoInput.h"


/*


PA2 goes to servo input

PA3-7, PA0-1 goes to  analog input  (on of those)

use two of either PA8, 9,   10, 
slaved with       PA7, PB0, PB1

PA7 and PA8 for high and low sides

PB6, 7 used for serial
PA13, 14, reset used for programming

some other random pin used for LED
some other random pin used for clockpin, for debugging


======
pins finally used by mike:
PA2: RC PWM
PA5: clockpin
PA8: gate drive



*/



DigitalOut clockpin(PA_5); 
DigitalOut led1(PB_1);  
DigitalIn gpio1(PA_6);  

//DigitalIn gpio2(PA_2); 


// controller modes
#define REST_MODE 0
#define VOLTAGE_MODE 1
#define CURRENT_MODE 2


volatile int count = 0;
volatile int main_int_count = 0;
volatile unsigned int main_int_clock = 0;

int controller_state = 0;


Serial pc(PB_6, PB_7);
Inverter inverter;
ServoTimer servoinp;


float a1 = 0.0f;
float a2 = 0.0f;


float current = 0.0f;
float current_raw = 0.0f;
float servo_cmd = 0.0f;


int servo_low = 890;
int servo_high = 1800;
int servo_range = servo_high - servo_low;




// Main 20khz loop Interrupt ///

extern "C" void TIM1_UP_TIM16_IRQHandler(void) {
  
  if (TIM1->SR & TIM_SR_UIF ) {

        main_int_count++;
        main_int_clock++;

        //
        //current_raw = float(ADC1->DR) - float(inverter.adc1_offset);
        current_raw = float(ADC1->DR) - 2000;
        //current_raw =  float(ADC1->DR));
        //current = current_raw*0.1f; //depends on shunts
        
        inverter.adc2_raw = ADC2->DR;
        inverter.adc1_raw = ADC1->DR;
        clockpin = 1;
        servoinp.update_servo_input();
        
        
        /// Check state machine state, and run the appropriate function ///
        switch(controller_state){
            case REST_MODE:   //nothing 
                TIM1->CCR1 = 6400;  
                count++;
                if(count > 20000){
                    count = 0;                                                    
                    led1 = !led1;
                }
                servo_cmd = servoinp.get_servo_input();
                
            break;
                
            
            case VOLTAGE_MODE: 
                
                servo_cmd = servoinp.get_servo_input();

                TIM1->CCR1 = 6400 - constrain((servo_cmd-880)*8.0f , 0, 6150);  //0 to 96% duty cycle

                if(count > 10000){ count = 0; }
                
            break;
            
            case CURRENT_MODE: 
                
                servo_cmd = servoinp.get_servo_input();
                /*
                float current_setpoint = (servo_cmd-880)/100;  //0 to 10 amps
                if (current > current_setpoint) {
                    //set bridge state to LOW
                    TIM1->CCR1 = 6100;
                }
                else {
                    TIM1->CCR1 = 300;
                }*/
                
                
                // servo inputs go from 880 to 1700
                
                // the constant in the next line is set 1800/servo_range
                //float current_setpoint_raw = (servo_cmd-servo_low)*2.25f;  //scales 800 range to 1800
                float current_setpoint_raw = constrain((servo_cmd-servo_low)*2.0f , 0, 800);  //scales 800 range to 1800
                if (current_raw > current_setpoint_raw) {
                    //set bridge state to LOW
                    TIM1->CCR1 = 6400;
                }
                else {
                    TIM1->CCR1 = 250;
                }
                
                
                if ((servo_cmd < servo_low) & (current_raw < 200) & (current_raw > -200)) {
                    TIM1->CCR1 = 6400;
                }
                
                
                if(count > 10000){ count = 0; }
                
            break;
            

        }  
            
      }
            //b = TIM1->CNT;
  TIM1->SR = 0x0;  
  clockpin = 0;                                                             // reset the status register
}

int main() {
    wait_ms(200);
    pc.baud(256000);
    printf("\rStarting Hardware\n");
    gpio1.mode(PullUp);

    
    inverter.Init();                     // Setup PWM, ADC
    wait(0.1);
    controller_state = REST_MODE;
    wait(0.1);
    inverter.zero_current();
    wait(0.1);
    pc.printf("ADCs zeroed at ");
    pc.printf("%i, %i \n",inverter.adc1_offset,inverter.adc2_offset);                                                 
    wait(0.1);
    inverter.ADCsync();

    

    //controller_state = VOLTAGE_MODE;
    controller_state = CURRENT_MODE;

    
    while(1) {

        wait_us(2);
        
        while (1==1) {
            
        wait_us(30);

        pc.printf("%f,  ", servo_cmd); 
        
        pc.printf("%f,  ", current_raw); 
        
        pc.printf("%f,  ", float(inverter.adc1_offset));
        pc.printf("%f,  ", a1); 
        pc.printf("%f,  ", a2); 
        
        
        //printf("%i,  ", b3); 
        //printf("%i,  ", b4);

        //pc.printf("%i, ", TIM15->CNT);  
        //pc.printf("%x  ", GPIOA->AFR[0]); 

        pc.printf("%i,  ", ADC1->DR);  
        pc.printf("%i,  ", ADC2->DR);
        //printf("    %i, %i %i", a1, a2, a3);
        //if (gpio2) {pc.printf("low ");}
        pc.printf("\r");


        }

    }
}







