#ifndef FW_CONFIG_H
#define FW_CONFIG_H

//hardware stuff
#define R_S 0.027f            //Ohms
#define L_S 0.00004f            //Henries



//current controler settings
#define KP 0.20f                     // Volts/Amp
#define KI 0.03f                  // 1/samples


#define V_BUS 24.0f                // Volts, actual bus voltage
#define MAX_AMPS 100.0f

#define D_INT_LIM V_BUS/(K_D*KI_D)  // Amps*samples
#define Q_INT_LIM V_BUS/(K_Q*KI_Q)  // Amps*samples


#define DT 0.00005f
#define F_SW 20000


#define DTC_MAX 0.95f          // Max phase duty cycle, determines current sensor read time
#define DTC_MIN 0.02f          // Min phase duty cycle



#endif

