#include "mbed.h"
#include "ServoInput.h"

//Takes servo inputs on PA2

ServoTimer::ServoTimer() {
    
    RCC->APB2ENR |= RCC_APB2ENR_TIM15EN;                                 // enable TIM2 clock
    
    __GPIOA_CLK_ENABLE(); //PA2 TIM15 Servo Input
     
    GPIOA->MODER   |= GPIO_MODER_MODER2_1;                                 //PA2 as Alternate Function 
    GPIOA->OTYPER  |= GPIO_OTYPER_OT_2;                                    //PA2  as Inputs               
    GPIOA->OSPEEDR |= GPIO_OSPEEDER_OSPEEDR2;                              //Low speed                         
    GPIOA->PUPDR   |= GPIO_PUPDR_PUPDR2_1;                                 //Pull Down                     
    //GPIOA->AFR[0]  |= 0x00000900 ;                                          //AF0          
    GPIOA->AFR[0]  |= 0x00000900 ;                                          //AF0  but Mbed is messed up. 
    GPIOA->AFR[0]  &= ~0x00000600 ;                                          //AF0  but Mbed is messed up.     
    GPIOA->AFR[1]  |= 0x00000000 ;                                          //AF1
    
    __TIM15_CLK_ENABLE();
    
    TIM15->PSC = 71;                   //timer counts a 1Mhz
    
    
    //TIM15->SMCR = 0b0000000001000100;   //TS = 100 (edge detection), SMS = 100 (trigger on counter reset)
    //TIM15->OR |= 0x2;
    
    //setting it up in PWM input capture mode
    //set CR1 to input mode?
    
    TIM15->SMCR = 0b0000000001010100;   //TS = 101 (input 1 detection), SMS = 100 reset mode
    
    
    TIM15->CCMR1 |= 0x200;                            // CC2S = 10, IC2 mapped to TI1
    TIM15->CCMR1 |= 0x1;                              // CC1S = 01, IC1 mapped to TI1
    TIM15->CCER |= TIM_CCER_CC1E | TIM_CCER_CC2E;     // Enable OC1 and OC2
    TIM15->CCER |= TIM_CCER_CC2P | TIM_CCER_CC2NP;    // set TI1FP2 to active on falling edge
    
    TIM15->CCMR1 |= TIM_CCMR1_IC1F_3;  //enable some filtering

    TIM15->CR1 = 0x01;
    
    trash_input_count = 2;
    oldCCR1 = 0;
    servo_sig = 0;
    
    
   
}

void ServoTimer::update_servo_input() {
    
    if (TIM15->CNT > 40000) {TIM15->CNT = 40000; trash_input_count=30;}  //pin stuck in some state
    
    
    if (((TIM15->SR)>>1) & (0x01)) {                  //if an edge has recently occurred
        
        if ((TIM15->CCR2 < 2000)&(TIM15->CCR2 > 800)) {
        //servo_sig = 0.95f*servo_sig + 0.05f*(float)TIM15->CCR2;
        
        trash_input_count = trash_input_count - 2; 
        
            if (trash_input_count < 20) {
                servo_sig = TIM15->CCR2;
            }
        }
        else {
            trash_input_count++; 
        }
    }
    
    
    

    
    if (trash_input_count>=20) { servo_sig = 800; }
    
    if (trash_input_count>=30) { trash_input_count=20; }
    if (trash_input_count<=0) { trash_input_count=0; }
    
}

int ServoTimer::get_servo_input() {
    return servo_sig;
}

int ServoTimer::get_trash_input() {
    return trash_input_count;
}

