#ifndef FW_CONFIG_H
#define FW_CONFIG_H

//hardware stuff
#define R_S 0.027f            //Ohms
#define L_S 0.00004f            //Henries

//#define KT .07f                 //N-m per peak phase amp (= RMS amps/1.5)
#define POLE_PAIRS 7                 //Number of pole pairs
#define ENC_TICKS_PER_REV 8191 //wank
//#define WB KT/NPP               //Webers.  



//current controler settings
#define K_D 0.25f                     // Volts/Amp
#define K_Q 0.25f                     // Volts/Amp

#define KI_D 0.03f                  // 1/samples
#define KI_Q 0.03f                  // 1/samples

/*
#define K_D 8.1f                     // Volts/Amp
#define K_Q 8.1f                     // Volts/Amp
#define KI_D 0.02f                  // 1/samples
#define KI_Q 0.02f                  // 1/samples
*/
#define V_BUS 14.0f                // Volts, actual bus voltage
#define V_CLIP 14.0f        // Volts, This is when the controller will nope out- not actually the real bus voltage
//#define V_BUS 6.0f                // Volts, actual bus voltage
//#define V_CLIP 6.0f        // Volts, This is when the controller will nope out- not actually the real bus voltage

#define D_INT_LIM V_BUS/(K_D*KI_D)  // Amps*samples
#define Q_INT_LIM V_BUS/(K_Q*KI_Q)  // Amps*samples

//#define MODULATION_FACTOR 0.574f // //perfect with zero clipping if v = v_bus, actually equal to 0.57735f * (DTC_MAX-DTC_MIN)
#define MODULATION_FACTOR 0.57f // //perfect with zero clipping if v = v_bus, actually equal to 0.57735f * (DTC_MAX-DTC_MIN)
//#define MODULATION_FACTOR 0.45f // //perfect with zero clipping if v = v_bus, actually equal to 0.57735f * (DTC_MAX-DTC_MIN)
#define USE_THETA_ADV false
#define MAX_AMPS 20.0f
#define DT 0.00005f
#define F_SW 20000


#define DTC_MAX 0.93f          // Max phase duty cycle
#define DTC_MIN 0.07f          // Min phase duty cycle


#define FL_OBS_LOWSPEED_MULT 0.995 //0.9992^2500 = 0.13 so lowpass will go to 0.18 every 8hz
#define FL_OBS_HIGHSPEED_MULT 0.95 //a lot faster






#endif

