
#include "foc.h"

//using namespace FastMath;
    
void svm(float v_bus, float u, float v, float w, float *dtc_u, float *dtc_v, float *dtc_w){
    ///u,v,w amplitude = v_bus for full modulation depth///
    
    float v_offset = (fminf3(u, v, w) + fmaxf3(u, v, w))/2.0f;
    *dtc_u = fminf(fmaxf(((u - v_offset)*MODULATION_FACTOR/v_bus + ((DTC_MAX+DTC_MIN)/2)), DTC_MIN), DTC_MAX);
    *dtc_v = fminf(fmaxf(((v - v_offset)*MODULATION_FACTOR/v_bus + ((DTC_MAX+DTC_MIN)/2)), DTC_MIN), DTC_MAX);
    *dtc_w = fminf(fmaxf(((w - v_offset)*MODULATION_FACTOR/v_bus + ((DTC_MAX+DTC_MIN)/2)), DTC_MIN), DTC_MAX);
    
    }


void reset_foc(FocStruct *controller){
    controller->q_int = 0;
    controller->d_int = 0;
    }


void commutate(FocStruct *controller){
       
    controller->loop_count ++;
//    controller->i_a = inverter->i_a; 
//    controller->i_b = inverter->i_b; 
//    controller->i_c = inverter->i_c;
    
    
    float s = sinf(controller->theta_elec); 
    float c = cosf(controller->theta_elec);
    //float s = FastSin(controller->theta_elec); 
    //float c = FastCos(controller->theta_elec);
                          
    controller->i_d = 0.6666667f*( c*controller->i_a + ( 0.86602540378f*s-.5f*c)*controller->i_b + (-0.86602540378f*s-.5f*c)*controller->i_c);   ///Faster DQ0 Transform
    controller->i_q = 0.6666667f*(-s*controller->i_a - (-0.86602540378f*c-.5f*s)*controller->i_b - ( 0.86602540378f*c-.5f*s)*controller->i_c);
       
    float i_d_error = controller->i_d_ref - controller->i_d;
    float i_q_error = controller->i_q_ref - controller->i_q;
    
    controller->d_int += i_d_error;   
    controller->q_int += i_q_error;
    limit_norm(&controller->d_int, &controller->q_int, V_CLIP/(K_Q*KI_Q));
        
    controller->v_d = K_D*i_d_error + K_D*KI_D*controller->d_int;// + v_d_ff;  
    controller->v_q = K_Q*i_q_error + K_Q*KI_Q*controller->q_int;// + v_q_ff; 
    
    limit_norm(&controller->v_d, &controller->v_q, V_CLIP);
    
    if (USE_THETA_ADV) {
        s = sinf(controller->theta_elec_adv); 
        c = cosf(controller->theta_elec_adv);
    }
    
    //s = FastSin(controller->theta_elec_adv); 
    //c = FastCos(controller->theta_elec_adv);
    
    controller->v_u = c*controller->v_d - s*controller->v_q;                // Faster Inverse DQ0 transform
    controller->v_v = ( 0.86602540378f*s-.5f*c)*controller->v_d - (-0.86602540378f*c-.5f*s)*controller->v_q;
    controller->v_w = (-0.86602540378f*s-.5f*c)*controller->v_d - ( 0.86602540378f*c-.5f*s)*controller->v_q;

    svm(V_BUS, controller->v_u, controller->v_v, controller->v_w, &controller->dtc_u, &controller->dtc_v, &controller->dtc_w); //space vector modulation
    
    //controller->dtc_u = 0.2;
    //controller->dtc_v = 0.2;
    //controller->dtc_w = 0.8;
    
//    focc->dtc_u = controller->dtc_u; 
//    inverter->dtc_v = controller->dtc_v; 
//    inverter->dtc_w = controller->dtc_w; 
    

    if(controller->loop_count >10000){
        controller->loop_count  = 0;
    }
}
    


       
void voltage_mode_commutate(FocStruct *controller){
       
    controller->loop_count ++;
    
    float s = sinf(controller->theta_elec); 
    float c = cosf(controller->theta_elec);
                           
    controller->i_d = 0.6666667f*( c*controller->i_a + ( 0.86602540378f*s-.5f*c)*controller->i_b + (-0.86602540378f*s-.5f*c)*controller->i_c);   ///Faster DQ0 Transform
    controller->i_q = 0.6666667f*(-s*controller->i_a - (-0.86602540378f*c-.5f*s)*controller->i_b - ( 0.86602540378f*c-.5f*s)*controller->i_c);
       
    
    limit_norm(&controller->v_d, &controller->v_q, V_CLIP);
    
    if (USE_THETA_ADV) {
        s = sinf(controller->theta_elec_adv); 
        c = cosf(controller->theta_elec_adv);
    }
    
    controller->v_u = c*controller->v_d - s*controller->v_q;                // Faster Inverse DQ0 transform
    controller->v_v = ( 0.86602540378f*s-.5f*c)*controller->v_d - (-0.86602540378f*c-.5f*s)*controller->v_q;
    controller->v_w = (-0.86602540378f*s-.5f*c)*controller->v_d - ( 0.86602540378f*c-.5f*s)*controller->v_q;

    svm(V_BUS, controller->v_u, controller->v_v, controller->v_w, &controller->dtc_u, &controller->dtc_v, &controller->dtc_w); //space vector modulation
            

    if(controller->loop_count >10000){
        controller->loop_count  = 0;
    }
}   
       
       
       
    
    
       
       
       
       
    
    