
#include "mbed.h"
#include "hw_pins.h"
//#include "hw_config.h"
#include "structs.h"
#include "FastPWM.h"

void Init_PWM(GPIOStruct *gpio){
    
    printf("\nStarting Hardware Function\n\r");
    
    RCC->AHB1ENR |= RCC_AHB1ENR_GPIOCEN;                        // enable the clock to GPIOC
    RCC->APB1ENR |= 0x00000001;                                 // enable TIM2 clock
    RCC->APB2ENR |= RCC_APB2ENR_TIM1EN;                         // enable TIM1 clock
    
    GPIOC->MODER |= (1 << 10);                                  // set pin 5 to be general purpose output for LED

    //gpio->enable = new DigitalOut(ENABLE_PIN);
    gpio->pwm_ul = new FastPWM(PIN_AL);
    gpio->pwm_vl = new FastPWM(PIN_BL);
    gpio->pwm_wl = new FastPWM(PIN_CL);
    gpio->pwm_uh = new FastPWM(PIN_AH);
    gpio->pwm_vh = new FastPWM(PIN_BH);
    gpio->pwm_wh = new FastPWM(PIN_CH);

    gpio->phasing = 1;
    
    
     //ISR Setup     
    
    NVIC_EnableIRQ(TIM1_UP_TIM10_IRQn);                         //Enable TIM1 IRQ
    
    TIM1->DIER |= TIM_DIER_UIE;                                 // enable update interrupt
    TIM1->CR1 = 0x40;                                          // CMS = 10, interrupt only when counting up
    TIM1->CR1 |= TIM_CR1_UDIS;  
    TIM1->CR1 |= TIM_CR1_ARPE;                                  // autoreload on, 
    TIM1->RCR |= 0x001;                                         // update event once per up/down count of tim1 
    TIM1->EGR |= TIM_EGR_UG;
    
    
        //PWM Setup
    TIM1->DIER |= TIM_DIER_UIE; // enable update interrupt
    TIM1->CR1 = 0x40;//CMS = 10, interrupt only when counting up
    
    TIM1->CR1 |= TIM_CR1_ARPE; // autoreload on, 
    TIM1->RCR |= 0x001; // update event once per up/down count of tim1 
    TIM1->EGR |= TIM_EGR_UG;
 
    
    //PWM Setup
    TIM1->PSC = 0x0; // no prescaler, timer counts up in sync with the peripheral clock
    TIM1->ARR = 0x1194; // 20 Khz
    //TIM1->BDTR |= TIM_BDTR_MOE;
    //TIM1->BDTR |= TIM_BDTR_OSSI;
    //TIM1->BDTR |= TIM_BDTR_OSSR;
    TIM1->BDTR |= 0xBF;
    TIM1->CCER |= TIM_CCER_CC1E | TIM_CCER_CC1NE | TIM_CCER_CC2E | TIM_CCER_CC2NE | TIM_CCER_CC3E | TIM_CCER_CC3NE;
    //TIM1->CCER |= ~TIM_CCER_CC1NP; //Interupt when low side is on.
    //TIM1->CCER |= TIM_CCER_CC1NP;
    TIM1->CR1 |= TIM_CR1_CEN;   
    

    }

void Init_ADC(void){
        // ADC Setup
     RCC->APB2ENR |= RCC_APB2ENR_ADC2EN;                        // clock for ADC2
     RCC->APB2ENR |= RCC_APB2ENR_ADC1EN;                        // clock for ADC1
    RCC->AHB1ENR |= RCC_AHB1ENR_GPIOCEN;                        // Enable clock for GPIOC
     
     ADC->CCR = 0x00000006;                                     // Regular simultaneous mode only
     ADC1->CR2 |= ADC_CR2_ADON;//0x00000001;                    // ADC1 ON
     ADC1->SQR3 = 0x000000A;                                    // use PC_0 as input  this is the V phase
     ADC2->CR2 |= ADC_CR2_ADON;//0x00000001;                    // ADC1 ON
     ADC2->SQR3 = 0x0000000B;                                   // use PC_1 as input. This is the U phase
     GPIOC->MODER |= 0x0000000f;                                // Alternate function, PC_0, PC_1 are analog inputs 

    }

void Init_DAC(void){
     RCC->APB1ENR |= 0x20000000;                                // Enable clock for DAC
     DAC->CR |= 0x00000001;                                     // DAC control reg, both channels ON
     GPIOA->MODER |= 0x00000300;                                // PA04 as analog output  
    }

void Init_All_HW(GPIOStruct *gpio){
    wait_ms(100);
    Init_ADC();
    wait(0.1);         
    
    //Init_DAC();
    wait(0.1);
    
    Init_PWM(gpio);
    
    }