#include "mbed.h"
#include "HWsetup.h"

//MicroLab, simplified. No DSA.


DigitalOut ledpin(LED1);              // LED output 
AnalogOut dac_1(PA_4);                // DAC output pin
DigitalOut comp_time(PA_12);           // D2
DigitalOut ref_trig(D6);



Serial pc(PA_2, PA_3);
int Lcount = 0;
float U_ref = 0.0f;
float U = 0.0f;
float Uv = 0.0f;
float Y = 0.0f;
int Yint = 0;
float ctrl_error = 0.0f;


extern "C" void TIM1_UP_TIM16_IRQHandler(void) {
  
  if (TIM1->SR & TIM_SR_UIF ) {
    //comp_time = 1;
    if ( TIM1->CR1 & TIM_CR1_DIR ) {
    
    comp_time = 1;
        
        while ((ADC1->ISR) & ADC_ISR_EOC == 0 ) {}       //   wait til ADC finishes conversion
        DAC->DHR12R1 = (ADC1->DR);                       //   set ADC value to DAC
        
        //set reference
        if (Lcount == 250) {            U_ref = 0.050f; ref_trig = 1;}   //50 mA
        if (Lcount == 500) {Lcount = 0, U_ref = 0.025f; ref_trig = 0;}   //25 mA
        Lcount++;
        
        
        // fix these
        float ADC_gain = 1.0f;
        float Current_gain = 1.0f;  
        Uv = int(ADC1->DR) * ADC_gain;              //   get ADC input in volts
        U = Uv * Current_gain;                         //   get U in amps, divide by resistor divider gain
        
        

        //controller
        ctrl_error = U_ref-U; 

        // Bang-bang controller is written below. Replace this with your PI controller.
        
        if (U > 4096*0.4f) { Y = 0.3f*1440.0f; }   // ADC readings scaled correctly
        if (U < 4096*0.2f) { Y = 0.7f*1440.0f; }
        
        
        // end controller

        float PWM_gain = 1.0f;      // fix this

        Yint = Y*PWM_gain;           //convert Y to integer and scale
        if (Yint > 1430) { Yint = 1430; }  // constrain
        if (Yint < 0) { Yint = 0; }        
        
        TIM1->CCR1 = Yint;  // set duty cycle
    
        


        }
    comp_time = 0;
    }
  TIM1->SR = 0x0;
}


int main() {
    
    wait_ms(200);
    pc.baud(115200);
    pc.printf(" bumping clock  ");       // set micro freq to 72MHz
    BumpClock();   // must be done before PWM setup, otherwise RCC gets confused
    pc.baud(102400);                     // actually 115200
    pc.printf(" clock ready ");
    wait_ms(50);
    Init_All_HW();                     // Setup PWM, ADC
    wait_ms(50);
    Init_ADC_Tim_Sync(); 
    wait_ms(5);
    TIM1->BDTR |= TIM_BDTR_MOE;    // enable switching
    TIM1->DIER |= TIM_DIER_UIE;    // start interrupt
    wait_ms(5);
    
    while(1) {
        //while(1) {}
        
        
        ledpin = !ledpin; // toggle LED
        pc.printf(" ADC raw: %i ",ADC1->DR);
        pc.printf("U, amps: %f ",U);
          pc.printf(" Y, volts: %f ",Y);
          pc.printf(" Y, PWM counts: %i ",Yint);
          pc.printf(" \r\n");



        
    }
}
