#include "mbed.h"
#include "HWsetup.h"


void Init_PWM(void){
    
    printf("\nStarting Hardware PWM\n\r");
    
    RCC->AHBENR |= RCC_AHBENR_GPIOAEN;                 // enable the clock to GPIOA
    RCC->AHBENR |= RCC_AHBENR_GPIOBEN;                 // enable the clock to GPIOA
    RCC->APB2ENR |= RCC_APB2ENR_TIM1EN;                // enable TIM1 clock

    
    //PWM Setup
    TIM1->CCMR1 |= 0x60;                             // Enable output compare 1 in PWM mode 1 
    TIM1->CCER |=  TIM_CCER_CC1E;                    // enable output 1
    TIM1->PSC = 0;                                   // set prescaler to 0
    TIM1->ARR = 1440;                               // set auto reload to 720- 100kHz but PWM is center aligned so zero
    TIM1->CR1 |= TIM_CR1_CMS_1;                      // Enable center-aligned PWM.
    TIM1->CR1 |= TIM_CR1_ARPE;                         // autoreload preload enable
    TIM1->CCMR1 |= TIM_CCMR1_OC1PE;                  // enable preloading of OC1
    RCC->CFGR3 |= RCC_CFGR3_TIM1SW;                    // bump tim1 up to 144MHz. 
    
    //hardware pin setup
    GPIOA->MODER   |= GPIO_MODER_MODER8_1 ;
    GPIOA->AFR[1]    |= 0x00000006;                    // PA8 to alternate function 6
    
    
    //interrupt generation
    NVIC_EnableIRQ(TIM1_UP_TIM16_IRQn);   //Enable TIM1 IRQ         
    TIM1->EGR |= TIM_EGR_UG;
    
    
    TIM1->CR1 |= TIM_CR1_CEN;   //go!
    
    }

void Init_ADC(void){
        // ADC Setup
    RCC->AHBENR |= RCC_AHBENR_GPIOAEN; 
    RCC->AHBENR |= RCC_AHBENR_ADC12EN;                        // clock for ADC1 and 2 enable 

    ADC12_COMMON->CCR |= 0x20001;                 // Regular simultaneous mode plus injected conversions
    
    
    ADC1->SQR1 = 0x40;                            // use PA_0 as input, ADC1 in1
    GPIOA->MODER |= 0b0000000011;                 // PA_0  analog input

    ADC2->CR |= ADC_CR_ADEN;   //must be done before SMPR1
    ADC1->CR |= ADC_CR_ADEN;
    
    ADC1->CFGR |= ADC_CFGR_OVRMOD;
    
    }
    




void Init_ADC_Tim_Sync() {
 
    ADC1->CFGR |= ADC_CFGR_EXTEN_0;
    ADC1->CFGR |= ADC_CFGR_EXTSEL_3 | ADC_CFGR_EXTSEL_1;  // set to event 10, tim1 TRGO2
    TIM1->CR2 |= TIM_CR2_MMS2_1;

    ADC1->CR  |= ADC_CR_ADSTART; 
}



void Init_JADC() {
      //must be run before ADC sync, as it cannot be run before ADC is enabled
      //must be run after ADCen
    
    GPIOA->MODER |= 0b1100;                        // PA_1 is analog input
    ADC1->JSQR = ADC_JSQR_JSQ1_1;                  // on ADC1 channel 2

    //GPIOA->MODER |= 0b110000000000;                 // PA_5 is analog input 
    //ADC2->JSQR = ADC_JSQR_JSQ1_1;                   // on ADC2 channel 2
     
}


void BumpClock() {
    
    //bumpclock function
    RCC->CR |= RCC_CR_HSEON;             //turn on HSE 
    RCC->CR |= RCC_CR_HSEBYP;            //use external clock input, not oscillator, comment out for crystal
    
    while (((RCC->CR)>>17)&0x1 == 0) {}       //wait til HSE is stable with HSERDY bit
    
    RCC->CFGR &= ~RCC_CFGR_SW_0 & ~RCC_CFGR_SW_1;  //use HSI as system clock- flying blind!
    RCC->CR &= ~RCC_CR_PLLON;                            //turn off PLL

    while (((RCC->CR)>>25)&0x1) {}                 //wait til PLL is off
    
    RCC->CFGR |= RCC_CFGR_PLLSRC;                  // set PLL source to HSE
    RCC->CFGR2 &= ~RCC_CFGR2_PREDIV_0 & ~RCC_CFGR2_PREDIV_1 & ~RCC_CFGR2_PREDIV_2 & ~RCC_CFGR2_PREDIV_3;// deselect all
    
    RCC->CFGR &= ~RCC_CFGR_PLLMUL_0 & ~RCC_CFGR_PLLMUL_1 & ~RCC_CFGR_PLLMUL_2 & ~RCC_CFGR_PLLMUL_3;  // deselect all
    RCC->CFGR |= RCC_CFGR_PLLMUL_0 | RCC_CFGR_PLLMUL_1 | RCC_CFGR_PLLMUL_2;  // set PLL multiplier to 9
    
    
    RCC->CFGR |= RCC_CFGR_SW_1;                    //reselect PLL as system clock
    RCC->CR |= RCC_CR_PLLON;
    while ( ((RCC->CR)>>25)&0x1 == 0 ) {}          //wait while PLL is starting up
    
    // APB1 prescaler = 2, APB1 limited to 36MHz, APB2 operates at full speed
    // RCC_CFGR: MCO = 100, Sysclk out
    // RCC_CFGR: PLLMUL = x9, PLLXTPRE is zero
    //           PLLSRC = 1, 1: HSE/PREDIV selected as PLL input clock 
    //  SWS = 10, PLL is systme clock
    //  SW = 10
    // PRE1 = 100; set APB1 to 2
    
    // check out PREDIV in RCC_CFGR2
    //APB1 prescaler = 2 for 36MHz, APB2 prescaler = 1
}


void Init_All_HW(void){
    wait_ms(100);
    Init_ADC();
    wait_ms(10);
    Init_JADC();
    wait(0.1);         
    
    //Init_DAC();
    //wait_ms(10);
    
    Init_PWM();
    

    
    }