#include "mbed.h"
#include "BufferedSerial.h"
#include"nRF24L01P.h"

Serial pc(PA_9, PA_10, 9600);//PA_9 PA_10 作为串口1连接串口转usb模块连接电脑
Serial JY901(PB_10,PB_11,9600);
//BufferedSerial mod(PB_10, PB_11, 32);//PB_10, PB_11作为第二个串口与jy-901的串口端连接，进行通信
//                 mosi, miso, sck, csn, ce, irq
nRF24L01P my_nrf24l01p(PA_7, PA_6, PA_5, PA_3, PA_4, PA_2);
//DigitalOut myled1(PC_13);

int state, token, payloadLen, recvLen;
unsigned char payloadBuf[16];

int main() {
    
    pc.printf("init\r\n");

#define TRANSFER_SIZE   4

    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int txDataCnt = 0;
    int rxDataCnt = 0;

    my_nrf24l01p.powerUp();

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setReceiveMode();//!!!!change this to change mode //setReceiveMode
    my_nrf24l01p.enable();

    while (1) {      
        if ( my_nrf24l01p.readable() ) {
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {
                pc.putc( rxData[i] );
            }
        }
        while(pc.readable()){
            txData[txDataCnt++] = pc.getc();
            if(txDataCnt>=sizeof(txData)){
                my_nrf24l01p.write(NRF24L01P_PIPE_P1,txData,txDataCnt);
                my_nrf24l01p.setReceiveMode();
                txDataCnt = 0;
            }       
        }
       
    }
     /*while(1){
            txData[txDataCnt++] = JY901.getc();
            if(txDataCnt>=sizeof(txData)){
                my_nrf24l01p.write(NRF24L01P_PIPE_P0,txData,txDataCnt);
                my_nrf24l01p.setReceiveMode();
                txDataCnt = 0;
            }       
           if ( my_nrf24l01p.readable() ) {
                rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P1, rxData, sizeof( rxData ) );
                for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {
                    pc.putc( rxData[i] );
                }
            }
    }*/
}
