
/**
 * @file    Buffer.cpp
 * @brief   Software Buffer - Templated Ring Buffer for most data types
 * @author  sam grove
 * @version 1.0
 * @see     
 *
 * Copyright (c) 2013
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
 /*void parseCmpt(int token, unsigned char* payloadBuf, int payloadLen)
{
    float data[3];
    switch(token){
        case 0x51:
            for (int i = 0; i < 3; ++i)
            {
                data[i] = payloadBuf[i*2]|((int)payloadBuf[i*2+1]<<8);
                data[i] = data[i] * 16 * 9.8 / 32768;
            }
            //pc.printf("Ax=%.2f\tAy=%.2f\tAz=%.2f\r\n", data[0], data[1], data[2]);
            break;
        case 0x52:
            for (int i = 0; i < 3; ++i)
            {
                data[i] = payloadBuf[i*2]|((int)payloadBuf[i*2+1]<<8);
                data[i] = data[i] * 2000 / 32768;
            }
            //pc.printf("Wx=%.2f\tWy=%.2f\tWz=%.2f\r\n", data[0], data[1], data[2]);
            break;
        case 0x53:
            for (int i = 0; i < 3; ++i)
            {
                data[i] = payloadBuf[i*2]|((int)payloadBuf[i*2+1]<<8);
                data[i] = data[i] * 180 / 32768;
            }
            pc.printf("Roll=%.2f\tPitch=%.2f\tYaw=%.2f\r\n", data[0], data[1], data[2]);
            break;
        case 0x54:
            for (int i = 0; i < 3; ++i)
            {
                data[i] = payloadBuf[i*2]|((int)payloadBuf[i*2+1]<<8);
            }
            //pc.printf("Hx=%.2f\tHy=%.2f\tHz=%.2f\r\n", data[0], data[1], data[2]);
            break;
    }
}
 
void parseInput(const char* data, int len)
{
    for (int i = 0; i < len; ++i)
    {
        unsigned char ch = data[i], sum;
        switch(state){
            case 0:
                if(ch == 0x55)
                    state = 1;
                break;
            case 1:
                token = ch;
                if(0x51 <= token && token <= 0x54){
                    payloadLen = 8;
                    recvLen = 0;
                    state = 2;
                }else{
                    pc.printf("%s %x\r\n", "unknown token", token);
                    state = 0;
                }
                break;
            case 2:
                payloadBuf[recvLen++] = ch;
                if(recvLen == payloadLen){
                    state = 3;
                }
                break;
            case 3:
                sum = 0x55;
                sum += token;
                for (int i = 0; i < payloadLen; ++i)
                {
                    sum += payloadBuf[i];
                }
                if(sum != ch){
                    pc.printf("wrong checksum\r\n");
                }else{
                    parseCmpt(token, payloadBuf, payloadLen);
                //    myled = !myled;
                }
                state = 0;
                break;
        }
    }
}*/
 
#include "MyBuffer.h"

template <class T>
MyBuffer<T>::MyBuffer(uint32_t size)
{
    _buf = new T [size];
    _size = size;
    clear();
    
    return;
}

template <class T>
MyBuffer<T>::~MyBuffer()
{
    delete [] _buf;
    
    return;
}

template <class T>
uint32_t MyBuffer<T>::getSize() 
{ 
    return this->_size; 
}

template <class T>
void MyBuffer<T>::clear(void)
{
    _wloc = 0;
    _rloc = 0;
    memset(_buf, 0, _size);
    
    return;
}

template <class T>
uint32_t MyBuffer<T>::peek(char c)
{
    return 1;
}

// make the linker aware of some possible types
template class MyBuffer<uint8_t>;
template class MyBuffer<int8_t>;
template class MyBuffer<uint16_t>;
template class MyBuffer<int16_t>;
template class MyBuffer<uint32_t>;
template class MyBuffer<int32_t>;
template class MyBuffer<uint64_t>;
template class MyBuffer<int64_t>;
template class MyBuffer<char>;
template class MyBuffer<wchar_t>;
