#include "mbed.h"
#include "stm32746g_discovery.h"
#include "stm32746g_discovery_ts.h"
#include "stm32746g_discovery_lcd.h"

I2C i2c(PB_9, PB_8);
const int addr = 0xA0;
TS_StateTypeDef  TS_State = {0};

int main()
{
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    int touchScreen=1;
    char heart_rate;
    
    /* Touchscreen initialization */
    if (BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize()) == TS_ERROR) {
        printf("BSP_TS_Init error\n");
    }
    
    /* Clear the LCD */
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    
     /* Set Touchscreen Demo1 description */
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_FillRect(0, 0, BSP_LCD_GetXSize(), 40);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
    BSP_LCD_SetFont(&Font24);
    BSP_LCD_DisplayStringAt(0, 0, (uint8_t *)"Touch to start heart rate", CENTER_MODE);
    
    
    while(touchScreen)
    {
        BSP_TS_GetState(&TS_State);
        if (TS_State.touchDetected)
        {
            touchScreen=0;
        }
    }
    
    
    //Board shape 270x480
    
    int i=0,j=0,h=136,etat=0;
    int tab[480];
    int rate=1,rate_start=0;
    char affichHeart [50],affich[50],affichi[50];
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);

    for(int x=0; x<480; x++)
    {
        BSP_LCD_DrawPixel(x,h,LCD_COLOR_RED);
        tab[x]=h;
    }

    

    while (1) {


    i2c.read(addr, &heart_rate, 1);
    rate=479-(479*((double)heart_rate/140.0));
    
    sprintf(affichHeart, "%d", heart_rate); 
    
     /* Set Touchscreen Demo1 description */
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_FillRect(0, 0, BSP_LCD_GetXSize(), 40);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
    BSP_LCD_SetFont(&Font24);
    BSP_LCD_DisplayStringAt(0, 0, (uint8_t *)affichHeart, CENTER_MODE);
    
        if (h==136)BSP_LCD_DrawPixel(i,h,LCD_COLOR_RED);
        else
        {
            BSP_LCD_DrawPixel(i,h,LCD_COLOR_RED);
        }
        tab[i]=h;
        HAL_Delay(3);
        
        i++;
        j=i+1;
        if (i>=479){i=0;}       
        if (j>=479){j=0;}
        if (rate==479)etat=3;
        sprintf(affich,"%d",etat);
        
        sprintf(affichi,"%d",i);
        switch(etat)
        {
            //Paterne BPM
            //Montant 136 -> 200
            case 0 :    BSP_LCD_DrawPixel(j,tab[j],LCD_COLOR_WHITE);
                        h=h+6;;
                        if (h>=200)etat=1;
                        break;
                        
            //Descendant 200->72
            case 1 :    BSP_LCD_DrawPixel(j,tab[j],LCD_COLOR_WHITE);
                        h=h-6;
    BSP_LCD_DisplayStringAt(0, 0, (uint8_t *) affichi,RIGHT_MODE);
                        if (h<=72)etat=2;
                        break;
                        
            //Montant 72 -> 136
            case 2 :    BSP_LCD_DrawPixel(j,tab[j],LCD_COLOR_WHITE);
                        h=h+6;
                        if (h>=136)etat=3;
                        break;
                        
            case 3 :    rate_start=i;
                        if ((rate_start+rate)>479)
                        {
                            rate_start=i-(rate_start+rate);
                        }
                        BSP_LCD_DrawPixel(j,tab[j],LCD_COLOR_WHITE);
                        if (rate!=479)etat=4;
                        break;
            
            //Tempo            
            case 4 :    BSP_LCD_DrawPixel(j,tab[j],LCD_COLOR_WHITE);
                        h=136;
                        if ((rate_start+rate)==i)etat=0;
                        break;
        }
        
        
        
    }
}
