// Lukas Bieri, Matthias, Manuel Meier & Noa Melchior 
// based on Work by Matthias Grob & Manuel Stalder 
// ETH 2017

#ifndef _FRAMES_H
#define _FRAMES_H

//the packed attribute makes sure the types only use their respective size in memory (8 bit for uint8_t), otherwise they would always use 32 bit
//IT IS A GCC SPECIFIC DIRECTIVE
struct __attribute__((packed, aligned(1))) RangingFrame {
    uint8_t source;
    uint8_t destination;
    uint8_t type;
};

struct __attribute__((packed, aligned(1))) ExtendedRangingFrame : RangingFrame{
    int signedTime;
};

struct __attribute__((packed, aligned(1))) StreamFrame : RangingFrame{
    uint8_t anchor_adress;
    float distance;
    float signalStrength;
    float FPLevel;
};

#endif /* _FRAMES_H */
