#ifndef _SMCONFIG_H_
#define _SMCONFIG_H_

#include "mbed.h"
#include "deca_device_api.h"
#include "deca_param_types.h"
//#include "frames.h"

#define DWT_PRF_64M_RFDLY   (515.2f)
#define DWT_PRF_16M_RFDLY   (514.7f)


struct ppsConfig_s {
  /*PPS_Role*/ int Role;

  PinName SpiMosi;
  PinName SpiMiso;
  PinName SpiClk;

  PinName DwCs;
  PinName DwIrq;
  PinName DwRst;

  PinName LedGreen;
  PinName LedRed;

  PinName BatIn;
  PinName Buzzer;
  PinName Vibra;

  PinName CanRx;
  PinName CanTx;
  PinName CanStandby;

  PinName I2cSda;
  PinName I2cScl;

  PinName DipSwitch0;
  PinName DipSwitch1;
  PinName DipSwitch2;
  PinName DipSwitch3;
  PinName DipSwitch4;
  PinName DipSwitch5;
  PinName DipSwitch6;
  PinName DipSwitch7;
};

typedef ppsConfig_s ppsConfig_t;

struct chConfig_t {
    uint8_t channel ;
    uint8_t prf ;
    uint8_t datarate ;
    uint8_t preambleCode ;
    uint8_t preambleLength ;
    uint8_t pacSize ;
    uint8_t nsSFD ;
    uint16_t sfdTO ;
};

struct tx_struct {
    uint8_t PGdelay;

    //TX POWER
    //31:24     BOOST_0.125ms_PWR
    //23:16     BOOST_0.25ms_PWR-TX_SHR_PWR
    //15:8      BOOST_0.5ms_PWR-TX_PHR_PWR
    //7:0       DEFAULT_PWR-TX_DATA_PWR
    uint32_t txPwr[2]; //
};

void SMsetconfig(uint8_t dr_mode, dwt_config_t *dw_config, dwt_txconfig_t *dw_configtx);
uint8_t SMpower(float gain);
float SMgain(uint8_t power);

extern const agc_cfg_struct agc_config ;

//SFD threshold settings for 110k, 850k, 6.8Mb standard and non-standard
extern const uint16_t sftsh[NUM_BR][NUM_SFD];

extern const uint16_t dtune1[NUM_PRF];

#define XMLPARAMS_VERSION  (1.17f)

extern const uint8_t pll2_config[NUM_CH][5];
extern const uint8_t pll2calcfg;
extern const uint8_t rx_config[NUM_BW];
//extern const uint32_t tx_config[NUM_CH];
extern const uint8_t dwnsSFDlen[NUM_BR];        //length of SFD for each of the bitrates
//extern const uint32_t digital_bb_config[NUM_PRF][NUM_PACS];
extern const uint8_t chan_idx[NUM_CH_SUPPORTED];

extern const uint16_t lde_replicaCoeff[PCODES];
extern const tx_struct txSpectrumConfig[NUM_CH_SUPPORTED];
extern const uint16_t rfDelays[NUM_PRF];

extern const chConfig_t chConfig[NUM_CH_SUPPORTED];
extern const float ChannelFrequency[NUM_CH_SUPPORTED];
extern const float ChannelBandwidth[NUM_CH_SUPPORTED];
extern const char* ChannelBitrate[3];
extern const char* ChannelPRF[3];
extern const uint8_t ChannelPAC[4];
extern uint16_t ChannelPLEN(uint8_t PLEN);

extern const tx_struct txSpectrumConfig[NUM_CH_SUPPORTED];
#endif

