#include "SMConfig.h"

void SMsetconfig(uint8_t dr_mode, dwt_config_t *dw_config,
    dwt_txconfig_t *dw_configtx) {

  dw_config->chan = chConfig[dr_mode].channel;
  dw_config->prf = chConfig[dr_mode].prf;
  dw_config->txPreambLength = chConfig[dr_mode].preambleLength;
  dw_config->rxPAC = chConfig[dr_mode].pacSize;
  dw_config->txCode = chConfig[dr_mode].preambleCode;
  dw_config->rxCode = chConfig[dr_mode].preambleCode;
  dw_config->nsSFD = chConfig[dr_mode].nsSFD;
  dw_config->dataRate = chConfig[dr_mode].datarate;
  dw_config->sfdTO = chConfig[dr_mode].sfdTO;
  dw_config->phrMode = DWT_PHRMODE_STD;
  //enable gating gain for 6.81Mbps data rate
  /*if (dw_config->dataRate == DWT_BR_6M8)
    dw_config->smartPowerEn = 1;
  else
    dw_config->smartPowerEn = 0;*/

  //dwt_setsmarttxpower(0);
  dw_configtx->power = txSpectrumConfig[dw_config->chan].txPwr[dw_config->prf
      - DWT_PRF_16M];
  dw_configtx->PGdly = txSpectrumConfig[dw_config->chan].PGdelay;

}

uint8_t SMpower(float gain) {
   if (gain <= 0.0f) {
     return 0xc0;
   } else if (gain > 18.0f+15.5f) {
     return 0x1f;
   } else {
     int gain_coarse_3;  // coarse gain in multiples of 3 dB
     int gain_fine_0_5;  // gine gain in multiples of 0.5 dB

     // set coarse gain first
     if (gain > 18) {
       gain_coarse_3 = 6;
     } else {
       gain_coarse_3 = (int)(gain/3);
     }

     // then set the fine gain
     gain_fine_0_5 = 2*(gain - gain_coarse_3);

     uint8_t result = ((6-gain_coarse_3)<<5) + gain_fine_0_5;

     return result;
   }
}


float SMgain(uint8_t power) {
  float gain_coarse = 3.0*(6-(power>>5));
  float gain_fine = 0.5*(power & 0x1f);
  return gain_coarse + gain_fine;
}


const chConfig_t chConfig[NUM_CH_SUPPORTED] = {
    { 1,             // channel // TKA was 2
        DWT_PRF_16M,    // prf
        DWT_BR_110K,    // datarate
        3,             // preambleCode
        DWT_PLEN_1024,  // preambleLength
        DWT_PAC32,      // pacSize
        1,       // non-standard SFD
        (1025 + 64 - 32) //SFD timeout
    },
    //mode 2
    { 2,              // channel
        DWT_PRF_16M,    // prf
        DWT_BR_6M8,    // datarate
        3,             // preambleCode
        DWT_PLEN_128,   // preambleLength
        DWT_PAC8,       // pacSize
        0,       // non-standard SFD
        (129 + 8 - 8) //SFD timeout
    },
    //mode 3
    { 2,              // channel
        DWT_PRF_64M,    // prf
        DWT_BR_110K,    // datarate
        9,             // preambleCode
        DWT_PLEN_1024,  // preambleLength
        DWT_PAC32,      // pacSize
        1,       // non-standard SFD
        (1025 + 64 - 32) //SFD timeout
    },
    //mode 4
    { 2,              // channel
        DWT_PRF_64M,    // prf
        DWT_BR_6M8,    // datarate
        9,             // preambleCode
        DWT_PLEN_128,   // preambleLength
        DWT_PAC8,       // pacSize
        0,       // non-standard SFD
        (129 + 8 - 8) //SFD timeout
    },
    //mode 5
    { 5,              // channel
        DWT_PRF_16M,    // prf
        DWT_BR_110K,    // datarate
        3,             // preambleCode
        DWT_PLEN_1024,  // preambleLength
        DWT_PAC32,      // pacSize
        1,       // non-standard SFD
        (1025 + 64 - 32) //SFD timeout
    },
    //mode 6
    { 5,              // channel
        DWT_PRF_16M,    // prf
        DWT_BR_6M8,    // datarate
        3,             // preambleCode
        DWT_PLEN_128,   // preambleLength
        DWT_PAC8,       // pacSize
        0,       // non-standard SFD
        (129 + 8 - 8) //SFD timeout
    },
    //mode 6
    { 5,              // channel
        DWT_PRF_64M,    // prf
        DWT_BR_110K,     // datarate
        9,             // preambleCode
        DWT_PLEN_1024,  // preambleLength
        DWT_PAC32,      // pacSize
        1,       // non-standard SFD
        (1025 + 64 - 32) //SFD timeout
    },
    //mode 7
    { 7,              // channel
        DWT_PRF_64M,    // prf
        DWT_BR_6M8,    // datarate
        9,             // preambleCode
        DWT_PLEN_128,   // preambleLength
        DWT_PAC8,       // pacSize
        0,       // non-standard SFD
        (129 + 8 - 8) //SFD timeout
    } };

const float ChannelFrequency[NUM_CH_SUPPORTED] = { 0.0, 3.49944, 3.9936, 4.4928,
    3.9936, 6.4896, 0, 6.4986 };
const float ChannelBandwidth[NUM_CH_SUPPORTED] = { 0.0, 0.4992, 0.4992, 0.4992,
    1.3312, 0.4992, 0, 1.0816 };
const char* ChannelBitrate[3] = {"110 kbits/s", "850 kbits/s", "6.8 Mbits/s"};
const char* ChannelPRF[3] = {"", "16 MHz", "64 MHz"};
const uint8_t ChannelPAC[4] = {8, 16, 32, 64};

uint16_t ChannelPLEN(uint8_t PLEN) {
  switch (PLEN) {
    case  DWT_PLEN_4096:
      return (uint16_t)4096;

    case DWT_PLEN_2048:
      return (uint16_t)2048;

    case DWT_PLEN_1536:
      return (uint16_t)1536;

    case DWT_PLEN_1024:
      return (uint16_t)1024;

    case DWT_PLEN_512:
      return (uint16_t)512;

    case DWT_PLEN_256:
      return (uint16_t)256;

    case DWT_PLEN_128:
      return (uint16_t)128;

    case DWT_PLEN_64:
      return (uint16_t)64;

    default:
      return 0;
  };

}




//The table below specifies the default TX spectrum configuration parameters... this has been tuned for DW EVK hardware units
//the table is set for smart power - see below in the instance_config function how this is used when not using smart power
const tx_struct txSpectrumConfig[NUM_CH_SUPPORTED] = {
//Channel 0 ----- this is just a place holder so the next array element is channel 1
    { 0x0,   //0
        { 0x0, //0
            0x0 //0
        } },
    //Channel 1
    { 0xc9,   //PG_DELAY
        { 0x15355575, //16M prf power
            0x07274767 //64M prf power
        }

    },
    //Channel 2
    { 0xc2,   //PG_DELAY
        { 0x15355575, //16M prf power
            0x07274767 //64M prf power
        } },
    //Channel 3
    { 0xc5,   //PG_DELAY
        { 0x0f2f4f6f, //16M prf power
            0x2b4b6b8b //64M prf power
        } },
    //Channel 4
    { 0x95,   //PG_DELAY
        { 0x1f1f3f5f, //16M prf power
            0x3a5a7a9a //64M prf power
        } },
    //Channel 5
    { 0xc0,   //PG_DELAY
        { 0x0E082848, //16M prf power
            0x25456585 //64M prf power
        } },
    //Channel 6 ----- this is just a place holder so the next array element is channel 7
    { 0x0,   //0
        { 0x0, //0
            0x0 //0
        } },
    //Channel 7
    { 0x93,   //PG_DELAY
        { 0x32527292,//0x51515151, //0xc0c0c0c0,//0x1f1f1f1f,//0x32527292, //16M prf power
           0x1f1f1f1f//0x5171B1d1//0x51515151//0xc0c0c0c0//0x1f1f1f1f// 0x5171B1d1 //64M prf power
        } } };

//these are default antenna delays for EVB1000, these can be used if there is no calibration data in the DW1000,
//or instead of the calibration data
const uint16_t rfDelays[NUM_PRF] = { (uint16_t) ((DWT_PRF_16M_RFDLY / 2.0f)
    * 1.0e-9f / DWT_TIME_UNITS), //PRF 16
    (uint16_t) ((DWT_PRF_64M_RFDLY / 2.0f) * 1.0e-9f / DWT_TIME_UNITS) //PRF 64
    };

