#include "PC.h"
#include "mbed.h"

PC::PC(PinName tx, PinName rx, int baudrate) : Serial(tx, rx) 
{
    baud(baudrate);
    cls();
    
    command[0] = '\0';
    command_char_count = 0;
}


void PC::cls() 
{
    printf("\x1B[2J");
}


void PC::locate(int Spalte, int Zeile) 
{
    printf("\x1B[%d;%dH", Zeile + 1, Spalte + 1);
}

void PC::readcommand(void (*executer)(char*))
{
    
    //printf("Reads");
    //while(1){
    char input = getc();  
    //printf("%c", input);           // get the character from serial bus
    //printf("\x1B[1K");
    //printf("-");
    
     if(input == '\r') {  
                   // if return was pressed, the command must be executed
        this->command[command_char_count] = '\0';
        executer(&command[0]);
        this->command_char_count = 0;                // reset command
        this->command[command_char_count] = '\0';
    //    break;
    } else if (command_char_count < COMMAND_MAX_LENGHT) {
       // printf("Debug Point 4");
        this->command[command_char_count] = input;
        //printf(command);
        this->command_char_count++;
      
    }
//}



    
   
/*   while (1)
    {
       
        if (readable())
        {
            scanf( "%s" , command );
            break;
        }
    }
    
   
    
    executer(&command[0]);
    command_char_count = 0;                 // reset command
    
   */ 



}
