#include "mbed.h"
 
#define IOS1 (0x100) // PA_8
#define IOS2 (0x40) // PA_6
#define IOS3 (0x80) // PA_7
#define RGB (0x200) // PA_9

Timer timer;
Serial pc(SERIAL_TX, SERIAL_RX);
DigitalIn button(USER_BUTTON);
PortOut GPIO1 (PortA, IOS1);
PortOut GPIO2 (PortA, IOS2);
PortOut GPIO3 (PortA, IOS3);
PortOut cLED (PortA, RGB);
DigitalOut LED(LED1);
int currentTime;
bool latch;
 
int main()
{
  latch = false;
  while(1)
  {
      // check button if pressed start timer and latch in.
      if ((button == 0) && (latch == false))
      {
            timer.reset();
            timer.start();
            latch = true;          
      }
      
      if (latch == true)
      {
          LED = 1;
          currentTime = timer.read_ms();
          //pc.printf("TIMER IS AT %d \n\r", currentTime);
          //wait(1);
          
          // set GPIO1 state
          if ((currentTime >= 0) && (currentTime < 10000))
          {
              GPIO1 = IOS1;
              cLED = RGB;
          }
          else
          {
              GPIO1 = 0;  
          }
          
          // set GPIO2 state
          if ((currentTime >= 3000) && (currentTime < 13000))
          {
              GPIO2 = IOS2;
          }
          else
          {
              GPIO2 = 0;   
          }
          
          // set GPIO3 state
          if ((currentTime >= 12000) && (currentTime < 22000))
          {
              GPIO3 = IOS3;
          }
          else
          {
              GPIO3 = 0;   
          }
          
          // check if sequence is over, stop timer and reset latch.
          if (currentTime > 22000)
          {
              latch = false;
              LED = 0;
              timer.stop();
          }
      }
  }
}