#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"
#include "GYRO_DISCO_F429ZI.h"

LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;
GYRO_DISCO_F429ZI gyro;

int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y, z1, z2, z3 ;
    uint8_t text[30];
    uint8_t textz1[30];
    uint8_t textz2[30];
    uint8_t textz3[30];
    uint8_t status;
    
    float GyroBuffer[3];
  
    BSP_LCD_SetFont(&Font20);
  
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"DEMO", CENTER_MODE);
    wait(1);
  
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
  
    if (status != TS_OK)
    {
      lcd.Clear(LCD_COLOR_RED);
      lcd.SetBackColor(LCD_COLOR_RED);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT FAIL", CENTER_MODE);
    }
    else
    {
      lcd.Clear(LCD_COLOR_GREEN);
      lcd.SetBackColor(LCD_COLOR_GREEN);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT OK", CENTER_MODE);
    }
    
    wait(1);
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    
    while(1)
    {
      gyro.GetXYZ(GyroBuffer);
      
      z1 = GyroBuffer[0];
      z2 = GyroBuffer[1];
      z3 = GyroBuffer[2];
      
      sprintf((char*)textz1, "g1=%d        ", z1);
      sprintf((char*)textz2, "g2=%d        ", z2);
      sprintf((char*)textz3, "g3=%d        ", z3);
      
      lcd.DisplayStringAt(0, LINE(1), (uint8_t *)&textz1, LEFT_MODE);
      lcd.DisplayStringAt(0, LINE(2), (uint8_t *)&textz2, LEFT_MODE);
      lcd.DisplayStringAt(0, LINE(3), (uint8_t *)&textz3, LEFT_MODE);
      
      wait(0.1);
      
      ts.GetState(&TS_State);      
      if (TS_State.TouchDetected)
      {
        x = TS_State.X;
        y = TS_State.Y;
        
        sprintf((char*)text, "x=%d y=%d    ", x, y);
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
        
      }
    }
}
