/* If you make any chnages to this file, then you must take the following steps.
**  1) compile and upload this program to FRDM-K64F
**  2) reset FRDM-K64F and wait for green light
**  3) connect FRDM-K64F and IPCU 2 to the same Ethernet switch
**  4) gain access to the IPCU 2 u-boot prompt
**  5) type 'run upenv' and press Enter
**  6) wait for green light
**  7) type 'run chkenv' and press Enter
       notice that there is an error, for example "byte at 0x0100033b (0x62) != byte at 0x0200033b (0x63)"
**  8) type 'md.b 2000x00 100' and press Enter
       replace the x with the base address in the error message
       in the example above the error was at 33b, so enter 'md.b 2000300 100' and press Enter
**  9) find the 'filesize' entry in the memory dump, and edit the filesize value below to match (case sensitive)
** 10) repeat steps 1 through 7 above, this time there should be no error message
*/
char *env_string[] = {
"addargs=setenv bootargs $bootargs ip=$ipaddr:$serverip:$gatewayip:$netmask:$hostname:$netdev:off console=$consoledev,$baudrate sdhci-of.max_clock=$sdclk\n",
"baudrate=115200\n",
"bootcmd=echo && echo This is a test environment. Must \"run upenv\" against && echo production server to restore production environment.\n",
"bootdelay=0\n",
"bootdrive=sda1\n",
"bootfile=uImage\n",
"chkenv=mw.b 1000000 0 1000 && tftpboot 1000000 $tftpdir/$ubootenv && mw.b 2000000 0 1000 && env export -t 2000000 && cmp.b 1000000 2000000 $filesize\n",
"consoledev=ttyS0\n",
"doboot=bootm $loadaddr - $fdtaddr;\n",
"dtboffset=180000\n",
"dtbsize=3500\n",
"envimport=if mmc part 0 && fatload mmc 0:1 $loadaddr $ubootenv; then env -d import $loadaddr $filesize && saveenv; else echo \"Missing file: $ubootenv\"; fi'\n",
"ethact=eTSEC1\n",
"ethprime=eTSEC1\n",
"ethtest=tftpboot 1000000 $tftpdir/ethtest_bin && sleep 3 && tftpboot 2000000 $tftpdir/ethtest_bin && cmp.b 1000000 2000000 $filesize\n",
"fdtaddr=ff0000\n",
"fdtfile=p1022ipcu_dtb\n",
"fileaddr=1000000\n",
"filesize=ce1\n",
"flashfsfile=flashfs_jffs2\n",
"flashfsoffset=A00000\n",
"flashfssize=600000\n",
"flashhdboot=run sethdargs addargs;nand read $fdtaddr $dtboffset $dtbsize;nand read $loadaddr $kernoffset $kernsize; run doboot;\n",
"gatewayip=192.168.1.1\n",
"hostname=ipcu\n",
"hwconfig=esdhc;\n",
"ipaddr=192.168.1.100\n",
"kernoffset=200000\n",
"kernsize=800000\n",
"loadaddr=1000000\n",
"minimalboot=run setminimalargs addargs; nand read $fdtaddr $dtboffset $dtbsize; nand read $loadaddr $kernoffset $kernsize; run doboot;\n",
"minimalfsfile=rootfs_jffs2\n",
"minimalfsoffset=1000000\n",
"minimalfssize=F000000\n",
"monitor=1\n",
"netdev=eth0\n",
"netmask=255.255.255.0\n",
"nfsargs=setenv bootargs root=/dev/nfs rw nfsroot=$serverip:$rootpath\n",
"nfsboot=run nfsargs addargs nfsget doboot;\n",
"nfsget=nfs $loadaddr $rootpath/boot/$bootfile; nfs $fdtaddr $rootpath/boot/$fdtfile;\n",
"ramboot=setenv bootargs root=/dev/ram rw console=$consoledev,$baudrate;tftp $ramdiskaddr $tftpdir/$ramdiskfile;tftp $loadaddr $tftpdir/$bootfile;tftp $fdtaddr $tftpdir/$fdtfile;bootm $loadaddr $tftpdir/$ramdiskaddr $fdtaddr\n",
"ramdiskaddr=2000000\n",
"ramdiskfile=uramdisk\n",
"rootpath=/opt/nfsroot\n",
"sdclk=22000000\n",
"serverip=192.168.1.10\n",
"sethdargs=setenv bootargs root=/dev/$bootdrive rw\n",
"setminimalargs=setenv bootargs tftpserver=$serverip tftpdir=$tftpdir root=/dev/mtdblock4 rw rootfstype=jffs2\n",
"tftpdir=/production\n",
"tftpkernel=setenv bootargs root=/dev/sda1 rw console=ttyS0,115200; tftpboot $loadaddr $tftpdir/$bootfile;tftpboot $fdtaddr $tftpdir/$fdtfile;run doboot\n",
"uboot=u-boot-nand_bin\n",
"ubootenv=u-boot-env_txt\n",
"updtb=tftpboot $loadaddr $tftpdir/$fdtfile; nand erase $dtboffset $filesize; nand write $loadaddr $dtboffset $filesize;\n",
"upenv=if tftpboot $loadaddr $tftpdir/$ubootenv; then env import -d $loadaddr $filesize && saveenv; else echo \"Missing file: $ubootenv\"; fi\n",
"upflashfs=tftpboot $loadaddr $tftpdir/$flashfsfile; nand erase $flashfsoffset $flashfssize; nand write $loadaddr $flashfsoffset $filesize;\n",
"upkernel=tftpboot $loadaddr $tftpdir/$bootfile; nand erase $kernoffset $filesize; nand write $loadaddr $kernoffset $filesize;\n",
"upminimal=tftpboot $loadaddr $tftpdir/$minimalfsfile; nand erase $minimalfsoffset $minimalfssize; nand write $loadaddr $minimalfsoffset $filesize;\n",
"upuboot=if tftpboot $loadaddr $tftpdir/$uboot; then nand erase 0 $filesize; nand write $loadaddr 0 $filesize; fi\n",
"usb_phy_type=ulpi\n",
"vtos=tftpboot 0x01000000 $tftpdir/vtos.ipcu.bin; go 0x01003000\n",
"\0" // end of table
};
