#include "mbed.h"
#include "DS3231.h"
#include "Thermistor.h"

 
#define read_addr 0xa0
#define write_addr 0xa1


 
I2C flash(PB_3, PB_10);
DS3231 rtc(PB_9, PB_8); 

AnalogIn bed(PB_0);

InterruptIn butt(PB_5);

//DigitalOut led(PA_4);
DigitalOut green(PA_0);
DigitalOut red(PA_1);

Serial pc(USBTX, USBRX);

void page_write(char addr1, char addr2, char data);
void page_read(char addr1, char addr2);
void write_byte(char addr1, char addr2, char data);
char read_byte(char addr1, char addr2, int range);

void callback();

int conv_hex_to_int(char data);

char buff[258];
char data[256];

int hour;
int minute;
int second;
int butt_flag = 0;

double temp_buff;
float temp;
double r;
double temp_tizedes;

int location = 2;
int eddmegafaszom = 0;

int main() {
    flash.frequency(100000);
    rtc.setI2Cfrequency(400000);
    pc.baud(115200);
    green = 1;
    red = 0;
    
    butt.fall(&callback);
    
    //pc.printf("\nI am ready! %02X  %02X\n", 0x1ff >> 8, 256 >> 8);
    
   location = 2;            //eeprom aktuális memória címnek a helye
    while(1) {
//gomb lenyomás után
        if(butt_flag != 0){     //gomb megnyomásához rendelt esemény
            red = 1;
            green = 1;
            read_byte(0x00, 0x00, location);        //"location" változó mennyiségében kiolvassa az adatokat az eepromból, és eltárolja majd a data tömbben. Ez a végén lévő függvényben valósul meg.
            if (location >= 750){                   //soros port lefagyása elleni védekező mechanizmus elje, ez bontja fel több max 750 db-os részre a data tömb elemeit.
                
                for (int i = 0; i < location/750; i++){
                    for (int j = i*750; j < (i + 1) * 750; j += 4){
                        pc.printf("%d:%d;%d.%d \n", data[i], data[i+1], data[i+2], data[i+3]);
                        wait_ms(10);
                    }
                    //wait_ms(50);
                }
                for (int i = location-(location%750); i <= location; i+=4){
                    
                    pc.printf("%d:%d;%d.%d \n", data[i], data[i+1], data[i+2], data[i+3]);
                }
            }
            else{                                           //ez a ciklus csak simán kitolja soros portra az adatokat, akkor lép bele, ha nincs 750 mért adat.
                for (int i = 2; i < location; i += 4){
                pc.printf("%d:%d;%d.%d \n", data[i], data[i+1], data[i+2], data[i+3]);
                wait_ms(10);
            }
            
            wait(0.5);
            location = 2;               //eeprom kihasználtságát kezdi előről, az elejétől kezdi újra felülírni az eepromot.
            wait(0.1);
            butt_flag = 0;              //gomb lenyomása utáni állapotot állítja vissza alap helyzetbe.
            red = 0;
            green = 1;
            rtc.setTime(0, 0, 0);       //rtc nullázása
        }
//fő ismétlődő ciklus eleje
        green = !green;                         //led bizgerálás
        //*************************************************************************************
        wait(20);                               //itt állítod be a mintavételi sebeggéget!!!!!!
        //*************************************************************************************
        rtc.readTime(&hour,&minute,&second);    //kolvasod az időt az rtc-ből

      double val=bed;                                                           //*
      double r=((1-val)/val)*4700;                                              //hőmérségkelt meghatározása
      temp = (1/(  log(r/10000) /3950 + 1/(25+273.15))-273.15)-20.0f;           //*
     
                                                                                //adatok beírésa az eepromba négyessével(óra, perc, hőfok 2 bíte-on)
            write_byte(location >> 8, location, (char)minute);
            location++;
            write_byte(location >> 8, location, (char)second);
            location++;
            write_byte(location >> 8, location, (char)floor(temp));
            location++;
            temp_tizedes = (temp-floor(temp))*100;
            write_byte(location >> 8, location, (char)temp_tizedes);
            location++;
            
            if (location >= 32000 && butt_flag == 0){                           //ez volt szar eddig, bocsika.... itt ezt a 32000-et tartsd meg aztán jó lesz minden :D
                red = !red;                                                     //lényegében csak belép egy végtelen ciklusba, hogy ha megtelik a memúria, és csak akkor lép ki, ha megnyomod a gombot, vagy úkraindítod a programot D:
                wait(0.2);
            }
    }
    }
}

void callback(){                //gomb interrupt függvénye
    
    butt_flag = 1;
    
}


void write_byte(char addr1, char addr2, char data){
    buff[0] = addr1;
    buff[1] = addr2;
    buff[2] = data;
    flash.write(write_addr, buff, 3, false);
    wait_ms(5);
}

char read_byte(char addr1, char addr2, int range){
    buff[0] = addr1;
    buff[1] = addr2;
    flash.write(write_addr, buff, 2, true);
    flash.read(read_addr, data, range, false);
    char faszom = data[0];
    return faszom;
}

    