 #include "mbed.h"
 #include "MFRC522.h"
 #include "beep.h"
#include "ds3231.h"
 
 //KL25Z Pins for MFRC522 SPI3 interface
 #define SPI_MOSI    PB_5
 #define SPI_MISO    PB_4
 #define SPI_SCLK    PB_3
 #define SPI_CS      PA_10
 
 #define address     0xd1
 // KL25Z Pin for MFRC522 reset
 #define MF_RESET    PB_1
 
 DigitalOut LedRed   (PC_5);
 DigitalOut LedGreen (PC_6);
 DigitalOut led (LED1);
 
 uint16_t cards[2][4] = {
                        {0x51, 0xf2, 0x05, 0x20},
                        {0x01, 0x02, 0x03, 0x04}
                        };
 
 Beep buzzer(PC_8);
 
 Serial     pc(USBTX, USBRX);
 MFRC522    RfChip   (PB_5, PB_4, PB_3, PB_10, PA_8);
 
 I2C rtc(PB_9, PB_8);
 
 void guttentag();
 int get_hour();
 int get_min();
 int set_time(int hour, int min);
 
 int main(void) {
   // Set debug UART speed
   pc.baud(115200);
 
   // Init. RC522 Chip
   RfChip.PCD_Init();
   
   rtc.frequency(100000);
   
   //set_time(0x23,0x58);
   int joez = 0;
   while (1) {
     
 
     // Look for new cards
     if ( ! RfChip.PICC_IsNewCardPresent())
     {
       
       wait_ms(100);
       led = !led;
       LedGreen = LedRed;
       LedRed = !LedRed;
       
       
       //pc.printf("%d:%d\n", get_hour(), get_min());
       continue;
     }
 
     LedRed   = 0;
 
     // Select one of the cards
     if ( ! RfChip.PICC_ReadCardSerial())
     {
       wait_ms(500);
       
       
       
       continue;
     }
    //wait(0.5);
    LedRed   = 0;
     LedGreen = 1;
     buzzer.beep(5000,0.2);
 
     // Print Card UID
     pc.printf("Card UID: ");
     for (uint8_t i = 0; i < RfChip.uid.size; i++)
     {
       pc.printf(" %X  ", RfChip.uid.uidByte[i]);
       if (RfChip.uid.uidByte[i] == cards[0][i]) joez++;
     }
     
     pc.printf("\n\r");
    
    if(joez == 4) {
        wait(0.8);
        buzzer.beep(4900, 3);
        pc.printf("\nbelephet\n");
        wait(3);
    }
    
    
    else{
        LedGreen= 0;
        for(int i = 0; i < 6; i++){
            buzzer.beep(5000, 0.5);
            LedRed = !LedRed;
            wait(1);
        }
    }
    joez = 0;
    LedRed = 1;
    
    char buf[3];    
        char data[10];
        buf[0] = 0x0; 
         rtc.write(address, buf, 1, true);
        rtc.read(address, data, 8, false);         
        for ( int i = 0; i < 8; i++){
            pc.printf("     %02X", data[i]);
        }
     
     //wait_ms(3000);
     
   }
 }
 
 void guttentag(){
     
}
int set_time(int hour, int min){
    char buf[3];
    buf[0] = 0x01;
    buf[1] = min;
    rtc.write(0xd0, buf, 2, false);
    buf[0] = 0x02;
    buf[1] = hour;
    rtc.write(0xd0, buf, 2, false);
    
    return 1;
}
int get_min()
{
    char buf[3];    
    char data[10];
    int min_val; 
    int min_hex; 
    buf[0] = 0x0;    

    rtc.write(address, buf, 1, true);
    rtc.read(address, data, 8, false);         
    min_hex = data[1];

    //-------------------------------------
    //----transfer hexa data to decimal----
    //-------------------------------------
    
    if ( min_hex >= 0x00 & min_hex < 0x10)
    {
        min_val = min_hex;
    }
    if ( min_hex >= 0x10 & min_hex < 0x20)
    {
        min_val = min_hex - 6;
    }
    if ( min_hex >=0x20 & min_hex <= 0x29)
    {
        min_val = min_hex - 12;
    }
    if ( min_hex >=0x30 & min_hex <= 0x39)
    {
        min_val = min_hex - 18;
    }
    if ( min_hex >=0x40 & min_hex <= 0x49)
    {
        min_val = min_hex - 24;
    }
    if ( min_hex >=0x50  & min_hex <= 0x59)
    {
        min_val = min_hex - 30;
    }
      
    return min_val;
}

int get_hour()
{
    
    char buf[3];    
    char data[10];
    int hour_val; 
    int hour_hex; 
    buf[0] = 0x00;    

    rtc.write(address, buf, 1, true);
    rtc.read(address, data, 8, false);         
    hour_hex = data[2];

    //-------------------------------------
    //----transfer hexa data to decimal----
    //-------------------------------------
    
    if ( hour_hex >= 0x00 & hour_hex < 0x10)
    {
        hour_val = hour_hex;
    }
    if ( hour_hex >= 0x10 & hour_hex < 0x20)
    {
        hour_val = hour_hex - 6;
    }
    if ( hour_hex >=0x20 & hour_hex <= 0x24)
    {
        hour_val = hour_hex - 12;
    }
    
    return hour_val;
}