#include "mbed.h"

// Ethernet
#include "EthernetInterface.h"
#include "HTTPClient.h"
EthernetInterface eth;
HTTPClient http;
#define WEBPAGE_BUF_SIZE 4096
char str[WEBPAGE_BUF_SIZE];

//LCD
#include "C12832_lcd.h"
C12832_LCD lcd;

// joystick pins and LED
BusIn joystick(p15,p12,p13,p16);
DigitalIn enter(p14);
BusOut led(LED1,LED2,LED3,LED4);
Ticker joystick_to_led;
void joystickHandler(void)
{
    led = (enter) ? 0xf : joystick;
}

// Accelerometer
#include "MMA7660.h"
MMA7660 accelerometer(p28, p27);

// RGB LED
PwmOut r(p23);
PwmOut g(p24);
PwmOut b(p25);

// Temp sensor
#include "LM75B.h"
LM75B temp(p28,p27);

//char const *URL = "http://mbed.org/media/uploads/donatien/hello.txt";
//char const *URL = "http://mbed.org/";
char const *URL = "http://www.att.com/";
char const MAC[] = {0x00,0x02,0xF7,0xF0,0x00,0x00};
void mbed_mac_address(char *mac)
{
    memcpy(mac, MAC, sizeof(MAC));
}

int main()
{
    r = g = b = 1.0f;
    joystick_to_led.attach(&joystickHandler, 0.001f);
    lcd.printf ("Bootstrap Complete!\n");

    // Prepare to use DHCP
    if (0 != eth.init()) {
        error("Init Failed\n");
    }
    // Try to get an IPAddress
    if (0 != eth.connect(30000)) {
        error("Connect Failed: Check ethernet connection or try to increase the timeout\n");
    }
    // Now we are part of the network
    printf("IP Address: %s\n", eth.getIPAddress());
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("TCP/IPv4: %s\n", eth.getIPAddress());
    //GET data
    printf("Trying to fetch page %s\n", URL);
    if(!http.get(URL, str, WEBPAGE_BUF_SIZE)) {
        printf("Page fetched successfully - read %d characters\n", strlen(str));
        printf("Result: %s\n", str);
    } else {
        printf("Error - HTTP return code = %d\n", http.getHTTPResponseCode());
    }
    eth.disconnect();

    while(1) {
        // print the temperature to the LCD
        float tmp_temp = (temp.read() * 1.8f ) + 32.0f;
        lcd.locate(8,10);
        lcd.printf("Temp: %.1fF", tmp_temp);

        // print and display the gyro data
        float x = fabs(accelerometer.x());
        float y = fabs(accelerometer.y());
        float z = fabs(accelerometer.z());
        r = 1.0f - x;
        g = 1.0f - y;
        b = z;
        lcd.locate(8,20);
        lcd.printf("X: %2.1f Y:%2.1f Z:%2.1f\n", x, y, z);

    }
}
