

#include "mbed.h"
#include "MODSERIAL.h"
#include "HIH_5030.h"
#include "ADXL345.h"
#include "I2C.h"

#define MESSAGE_BUFFER_SIZE 100

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
AnalogIn ain_UseA(p15);
//AnalogIn ain_UseB(p16); //pins 16-19 are tied to ground to reduce noise
//AnalogIn ain_UseC(p17);
//AnalogIn ain_UseD(p18);
//AnalogIn ain_UseE(p19);
ADXL345 accelerometer(p5, p6, p7, p8);
I2C i2c(p28, p27);

MODSERIAL messageSystem(p13, p14);

unsigned char messageBufferIncoming[MESSAGE_BUFFER_SIZE];
unsigned int hexBufferIncoming[MESSAGE_BUFFER_SIZE];
unsigned char messageBufferOutgoing[MESSAGE_BUFFER_SIZE];
int count = 0;
int i = 0;
bool messageReceived;


void messageReceive(MODSERIAL_IRQ_INFO *q) {
    // Get the pointer to MODSERIAL object that invoked this callback.
    MODSERIAL *sys = q->serial;
    
    //dereference rxGetLasChar() of sys object 
    unsigned int c = sys->rxGetLastChar(); // Returns the last byte to pass through the RX interrupt handler.
    
    //add the character that triggered the interrupt to the incoming buffers
    //I'm adding to an in buffer and a char buffer, but using the int buffer to determine which message it is
        //if I want to use the char buffer to determine, then I need to use strcmp instead of =
    if(i <=MESSAGE_BUFFER_SIZE){
        messageBufferIncoming[i] = c;
        hexBufferIncoming[i] = c;
        i++;
        }     
    count++;
    if (count == 4){ //TODO: Determine if I need to be able to find a message anywhere within a bigger buffer
         //led4 = !led4;
            if (hexBufferIncoming[0] == 0xAA){              //Start Calibration
                if (hexBufferIncoming[1] == 0x55){
                    if (hexBufferIncoming[2] == 0xFF){
                        if (hexBufferIncoming[3] == 0x00){
                            led1 = !led1;
                            //TODO: Determine if I need to add disable interrupt.  What happens if I receive while transmitting???
                            messageSystem.printf("%c", messageBufferOutgoing[0]= 0xAB);              
                            messageSystem.printf("%c", messageBufferOutgoing[1] = 0x54);
                            messageSystem.printf("%c", messageBufferOutgoing[2] = 0xFF);
                            messageSystem.printf("%c", messageBufferOutgoing[3] = 0x00);

                            }
                        }
                    }
                }
            
         else if (hexBufferIncoming[0] == 0xBB){                //Stop Calibration
                if (hexBufferIncoming[1] == 0x44){
                    if (hexBufferIncoming[2] == 0xFF){
                        if (hexBufferIncoming[3] == 0x00){
                            led2 = !led2;
                            messageSystem.printf("%c", messageBufferOutgoing[0]= 0xBC);
                            messageSystem.printf("%c", messageBufferOutgoing[1]= 0x43);
                            messageSystem.printf("%c", messageBufferOutgoing[2]= 0xFF);
                            messageSystem.printf("%c", messageBufferOutgoing[3]= 0x00);
                            }
                        }
                    }
                }
                
        else if (hexBufferIncoming[0] == 0xCC){                //Get Calibration Value   Leave room for data bits          
                if (hexBufferIncoming[1] == 0x33){
                    if (hexBufferIncoming[2] == 0xFF){
                        if (hexBufferIncoming[3] == 0x00){
                            led3 = !led3;
                            messageSystem.printf("%c", messageBufferOutgoing[0]= 0xCD);
                            messageSystem.printf("%c", messageBufferOutgoing[1]= 0x32);
                            messageSystem.printf("%c", messageBufferOutgoing[2]= 0xFF);
                            messageSystem.printf("%c", messageBufferOutgoing[3]= 0x00);
                            }
                        }
                    }
                }     
        else if (hexBufferIncoming[0] == 0xDD){                 //Get Dynamic Data  Leave room for data bits
                if (hexBufferIncoming[1] == 0x22){
                    if (hexBufferIncoming[2] == 0xFF){
                        if (hexBufferIncoming[3] == 0x00){
                            led4 = !led4;
                            messageSystem.printf("%c", messageBufferOutgoing[0]= 0xDE);
                            messageSystem.printf("%c", messageBufferOutgoing[1]= 0x21);
                            messageSystem.printf("%c", messageBufferOutgoing[2]= 0xFF);
                            messageSystem.printf("%c", messageBufferOutgoing[3]= 0x00);
                            }
                        }
                    }
                }  
        else if (hexBufferIncoming[0] == 0xDB){             //Get Heading //Add space for responses
                if (hexBufferIncoming[1] == 0x24){
                    if (hexBufferIncoming[2] == 0xFF){
                        if (hexBufferIncoming[3] == 0x00){
                            led1 = !led1;
                            messageSystem.printf("%c", messageBufferOutgoing[0]= 0xDC);
                            messageSystem.printf("%c", messageBufferOutgoing[1]= 0x23);
                            messageSystem.printf("%c", messageBufferOutgoing[2]= 0x00);
                            messageSystem.printf("%c", messageBufferOutgoing[3]= 0x00);
                            }
                        }
                    }
                }    
        else if (hexBufferIncoming[0] == 0xD9){             //Get Temperature //Add space for response
                if (hexBufferIncoming[1] == 0x26){
                    if (hexBufferIncoming[2] == 0xFF){
                        if (hexBufferIncoming[3] == 0x00){
                            led2 = !led2;
                            messageSystem.printf("%c", messageBufferOutgoing[0]= 0xDA);
                            messageSystem.printf("%c", messageBufferOutgoing[1]= 0x25);
                            messageSystem.printf("%c", messageBufferOutgoing[2]= 0x00);
                            messageSystem.printf("%c", messageBufferOutgoing[3]= 0x00);
                            }
                        }
                    }
                }     
        else if (hexBufferIncoming[0] == 0xEE){             //Get Elapsed Time On //Add space for response
                if (hexBufferIncoming[1] == 0x11){
                    if (hexBufferIncoming[2] == 0x00){
                        if (hexBufferIncoming[3] == 0x01){
                            led3 = !led3;
                            messageSystem.printf("%c", messageBufferOutgoing[0]= 0xEF);
                            messageSystem.printf("%c", messageBufferOutgoing[1]= 0x10);
                            messageSystem.printf("%c", messageBufferOutgoing[2]= 0x00);
                            messageSystem.printf("%c", messageBufferOutgoing[3]= 0x00);
                            }
                        }
                    }
                }      
         memset(messageBufferIncoming, '\0', sizeof(messageBufferIncoming));
         memset(hexBufferIncoming, '\0', sizeof(hexBufferIncoming));
         memset(messageBufferOutgoing, '\0', sizeof(messageBufferOutgoing));
         i = 0;
         messageReceived = true;
         count = 0;
         }
    return;
}

void messageProcess(void) { 
     //  led1 = !led1;
    messageReceived = false;
}
/*
Constructor
dataPin: the IO pin connected to the sensor's data pin (pin 15)
supplyVoltage: the voltage supplying the humidity sensor (pins 1,3 - for the HIH5030 3.3 V typical)
referenceVoltage: motor controller's reference voltage (3.3V for the LPC1768)
*/

HIH5030::HIH5030(float dataPin, float supplyVoltage, float referenceVoltage){

pin = dataPin;
vSupply = supplyVoltage;
vRef = referenceVoltage;

/*
Relative Humidity is calculated using the following equations taken from the datasheet:
(1) Vout = (VSupply)(0.00636(sensorRH) + 0.1515)
(2) sensorRH = (Vout - zeroOffset) / slope

Solving (1) for sensorRH: 
sensorRH = (Vout - (0.1515)VSupply) / (0.00636)VSupply

Equate result with (2):
zeroOffset = (0.1515)VSupply
slope = (0.00636)VSupply
*/ 

slope = 0.00636 * vSupply;
zeroOffset = 0.1515 * vSupply; 

}


/*
Convert sensor reading into relative humidity using equation (2)
*/ 

float HIH5030::getSensorRH() {
return ((vout() - zeroOffset) / slope);

}

/*
Get temperature-compensated relative humity. From data sheet: 
trueRH = sensorRH / (1.0546 - 0.00216T)
*/

float HIH5030::getTrueRH(float temperature) { 
return getSensorRH() / (1.0546 - (0.00216 * temperature)); 

}

/*
Get sensor output voltage.
Assumes 12-bit (2^16 = 4096) A/D resolution.
*/

float HIH5030::vout() {
return (float)(ain_UseA.read_u16()) * 3.3 / 65536;

}
void ADXL345::getOutput(int* readings){

    char buffer[6];
    
    multiByteRead(ADXL345_DATAX0_REG, buffer, 6);
    
    readings[0] = (int)buffer[1] << 8 | (int)buffer[0];
    readings[1] = (int)buffer[3] << 8 | (int)buffer[2];
    readings[2] = (int)buffer[5] << 8 | (int)buffer[4];

}

void ADXL345::multiByteRead(int startAddress, char* buffer, int size) {

    int tx = (ADXL345_SPI_READ | ADXL345_MULTI_BYTE | (startAddress & 0x3F));

    nCS_ = 0;
    //Send address to start reading from.
    spi_.write(tx);

    for (int i = 0; i < size; i++) {
        buffer[i] = spi_.write(0x00);
    }

    nCS_ = 1;

}

//ACCELEROMETER

ADXL345::ADXL345(PinName mosi, 
                 PinName miso, 
                 PinName sck, 
                 PinName cs) : spi_(mosi, miso, sck), nCS_(cs) {

    //2MHz, allowing us to use the fastest data rates.
    spi_.frequency(2000000);
    spi_.format(8,3);
    
    nCS_ = 1;

    wait_us(500);

}

//ACCELEROMETER

int main() {

    messageReceived = false;
    memset(messageBufferIncoming, '\0', sizeof(messageBufferIncoming));
    memset(hexBufferIncoming, '\0', sizeof(hexBufferIncoming));
    memset(messageBufferOutgoing, '\0', sizeof(messageBufferOutgoing));
    messageSystem.baud(9600);
    messageSystem.attach(&messageReceive, MODSERIAL::RxIrq); //Attach a C++ type object/method pointer as the callback.
   
    // Fix Mbed library bug, see http://mbed.org/forum/bugs-suggestions/topic/1498
    LPC_GPIOINT->IO2IntClr = (1UL << 5) | (1UL << 4) | (1UL << 3) | (1UL << 2); 
 \
    while(1) {
        //led1 = !led1;
        wait(.05);
        float ad[5];
    float supplyvoltage = 3.3;
    float referencevoltage = 3.3;
    float vdiv = (3.3 / 65536); //3.3 is the reference voltage (AnalogIn measures from 0V to 3.3V) and 65536 is the highest number that can be represented by a 16 bit unsigned
    while( 1 ){
        ad[0] = (float)ain_UseA.read_u16() * vdiv;  //16-bit unsigned short representing the current input voltage, normalised to a 16-bit value 
      //  ad[1] = (float)ain_UseB.read_u16() * vdiv;
      //  ad[2] = (float)ain_UseC.read_u16() * vdiv;
      //  ad[3] = (float)ain_UseD.read_u16() * vdiv;
      //  ad[4] = (float)ain_UseE.read_u16() * vdiv;
        //pc.printf("%5.3f,%5.3f,%5.3f,%5.3f,%5.3f\r\n ", ad[0],ad[1],ad[2],ad[3],ad[4]);
        HIH5030 humidity(ad[0], supplyvoltage, referencevoltage);
        messageSystem.printf("Humidity: %5.3f\r\n", humidity.getSensorRH());
    led3 = 1;
    wait(2.0);
    led3 = 0;
    wait(2.0);
    
    ///ACCELEROMETER
    
     int readings[3] = {0, 0, 0};
    
  //  messageSystem.printf("Starting ADXL345 test...\n");
 //   messageSystem.printf("Device ID is: 0x%02x\n", accelerometer.getDevId());

    //Go into standby mode to configure the device.
   // accelerometer.setPowerControl(0x00);

    //Full resolution, +/-16g, 4mg/LSB.
   // accelerometer.setDataFormatControl(0x0B);
    
    //3.2kHz data rate. Changed from 3.2k to 25Hz
  //  accelerometer.setDataRate(ADXL345_25HZ);

    //Measurement mode.
 //   accelerometer.setPowerControl(0x08);
    
        wait(0.1);
        
        accelerometer.getOutput(readings);
        
        //13-bit, sign extended values.
        messageSystem.printf("X:%i, Y:%i, Z:%i \r\n", (int16_t)readings[0], (int16_t)readings[1], (int16_t)readings[2]);
        led4 = !led4;
    
    ///ACCELEROMETER
    
    //ETC
    unsigned char ttal, ttalm, ttahm, ttalh, evntl, evnth;
    long int tmp;

    i2c.start();
    i2c.write(0xD6);
    i2c.write(5);
    i2c.start();
    i2c.write(0xD6  | 1);
    ttal = i2c.read(5);
    ttalm = i2c.read(6);
    ttahm = i2c.read(7);
    ttalh = i2c.read(8);
    i2c.stop();
    tmp = ((long int) ttalh << 24) + ((long int) ttahm << 16) + ((long int) ttalm << 8) + (long int) ttal;
    tmp >>= 2;
    messageSystem.printf("Event Time: %d sec \r\n", tmp);
    i2c.stop();
    
    
    //ETC
    }
    
    
        if (messageReceived)
        {
        //led2 = !led2;
        messageProcess();
         }
    }
}
